/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration.target;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;
import org.arquillian.droidium.container.configuration.target.TARGET_TYPE;
import org.arquillian.droidium.container.configuration.target.TagAbiPair;
import org.arquillian.droidium.container.configuration.target.Target;
import org.arquillian.droidium.container.configuration.target.TargetRegistry;
import org.jboss.arquillian.core.spi.Validate;

public class TargetPicker {
    private static final Logger logger = Logger.getLogger(TargetPicker.class.getName());
    private final TargetRegistry targetRegistry;
    private final AndroidContainerConfiguration configuration;

    public TargetPicker(TargetRegistry targetRegistry, AndroidContainerConfiguration configuration) {
        Validate.notNull((Object)targetRegistry, (String)"Target registry is null!");
        Validate.notNull((Object)configuration, (String)"Configuration is null!");
        this.targetRegistry = targetRegistry;
        this.configuration = configuration;
    }

    public Target pick() {
        if (this.targetRegistry.getTargets().isEmpty()) {
            logger.log(Level.INFO, "There are no targets to choose from! It means you are not able to deal with AVD creation , you are supposed to work only with physical Android device and you can deal only with Droidium container and not with any Droidium extensions using instrumentation.");
            return null;
        }
        String target = this.configuration.getTarget();
        Target pickedTarget = null;
        if (target == null || target.isEmpty()) {
            pickedTarget = this.targetRegistry.getHighest(TARGET_TYPE.PLATFORM);
            if (pickedTarget == null) {
                pickedTarget = this.targetRegistry.getHighest(TARGET_TYPE.ADD_ON);
            }
            if (pickedTarget == null) {
                throw new AndroidContainerConfigurationException("You have not set target in the Android container configuration and it is impossible to choose it.");
            }
        } else {
            pickedTarget = this.targetRegistry.getByIdLabel(target);
            if (pickedTarget == null && this.isNumber(target)) {
                List<Target> pickedTargets = this.targetRegistry.getByApiLevel(target);
                for (Target t : pickedTargets) {
                    if (!t.isPlatorm()) continue;
                    pickedTarget = t;
                }
                if (pickedTarget == null) {
                    pickedTarget = pickedTargets.iterator().next();
                }
            }
        }
        if (pickedTarget == null) {
            logger.log(Level.INFO, "Unable to resolve target: {0}. You can operate only on a real physical device and you can not deal with emulators.", new Object[]{target});
            return null;
        }
        this.configuration.setTarget(pickedTarget.getIdLabel());
        List<TagAbiPair> availableTagAbis = pickedTarget.getAbis();
        if (!availableTagAbis.isEmpty()) {
            TagAbiPair resolvedTagAbiPair = TagAbiPair.construct(this.configuration.getAbi());
            if (resolvedTagAbiPair == null) {
                resolvedTagAbiPair = TagAbiPair.construct("default/" + this.configuration.getAbi());
            }
            if (availableTagAbis.contains(resolvedTagAbiPair)) {
                this.configuration.setAbi(resolvedTagAbiPair.toString());
            } else {
                List<TagAbiPair> defaultAbis = pickedTarget.getDefaultAbis();
                if (defaultAbis.isEmpty()) {
                    this.configuration.setAbi(availableTagAbis.iterator().next().toString());
                } else {
                    this.configuration.setAbi(defaultAbis.iterator().next().toString());
                }
            }
        } else {
            logger.log(Level.INFO, "Resolved target {0} does not contain any ABIs so you can operate only on real physical devices and you can not deal with emulators.", new Object[]{pickedTarget.getName()});
            return null;
        }
        return pickedTarget;
    }

    private boolean isNumber(String number) {
        try {
            Integer.parseInt(number);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

