/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.IOException;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceOutputReciever;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.spi.AndroidDeployment;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.droidium.container.utils.Monkey;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.task.os.CommandTool;

public class AndroidApplicationManager {
    private static final Logger logger = Logger.getLogger(AndroidApplicationManager.class.getName());
    private AndroidDevice device;
    private final AndroidSDK sdk;
    private static final String TOP_CMD = "top -n 1";
    private static final String PACKAGES_LIST_CMD = "pm list packages -f";

    public AndroidApplicationManager(AndroidDevice device, AndroidSDK sdk) {
        Validate.notNull(device, "Android device you are trying to pass to Android application manager is a null object!");
        Validate.notNull(sdk, "Android SDK you are trying to pass to Android application manager is a null object!");
        this.device = device;
        this.sdk = sdk;
    }

    public void install(AndroidDeployment deployment) {
        Validate.notNull(deployment, "Android deployment you are trying to pass is a null object!");
        Validate.notNull(deployment.getResignedApk(), "Application to install is a null object!");
        Validate.notNull(deployment.getApplicationBasePackage(), "Application base package name is a null object!");
        Command installCommand = new CommandBuilder((CharSequence)this.sdk.getAdbPath()).parameters(new CharSequence[]{"-s"}).parameter((CharSequence)this.device.getSerialNumber()).parameter((CharSequence)"install").parameter((CharSequence)deployment.getResignedApk().getAbsolutePath()).build();
        logger.fine("AUT installation command: " + installCommand.toString());
        String applicationBasePackage = deployment.getApplicationBasePackage();
        if (this.device.isPackageInstalled(applicationBasePackage)) {
            this.device.uninstallPackage(applicationBasePackage);
        }
        ProcessResult processDetails = null;
        try {
            processDetails = (ProcessResult)((CommandTool)Spacelift.task(CommandTool.class)).addEnvironment(this.sdk.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).command(installCommand).execute().await();
        }
        catch (ExecutionException e) {
            throw new AndroidExecutionException((Throwable)e, "Unable to execute installation command '{0} {1}' for the application {2}. Execution ended with exit code {3} with output\n{4}", new Object[]{this.sdk.getAdbPath(), installCommand, applicationBasePackage, processDetails.exitValue(), processDetails.output()});
        }
        if (!this.device.isPackageInstalled(applicationBasePackage)) {
            throw new AndroidExecutionException("Application " + applicationBasePackage + " was not installed on device " + this.device.getSerialNumber() + ".");
        }
    }

    public void uninstall(AndroidDeployment deployment) {
        Validate.notNull(deployment, "Android deployment you are trying to uninstall can not be a null object!");
        Validate.notNull(deployment.getApplicationBasePackage(), "Application base package can not be a null object!");
        StringBuilder sb = new StringBuilder();
        String command = sb.append("pm ").append("uninstall ").append(deployment.getApplicationBasePackage()).toString();
        try {
            Monkey monkey = new Monkey(DroidiumFileUtils.createRandomEmptyFile(this.sdk.getPlatformConfiguration().getTmpDir()), deployment.getApplicationBasePackage(), false);
            this.device.executeShellCommand(command, (AndroidDeviceOutputReciever)monkey);
            Monkey.wait(this.device, monkey, PACKAGES_LIST_CMD);
        }
        catch (IOException ex) {
            throw new AndroidExecutionException("Unable to uninstall application " + deployment.getApplicationBasePackage() + " from Android device.");
        }
    }

    public void disable(AndroidDeployment deployment) {
        Validate.notNull(deployment, "Android deployment you are trying to kill can not be a null object!");
        Validate.notNull(deployment.getApplicationBasePackage(), "Application base package name can not be a null object!");
        StringBuilder sb = new StringBuilder();
        String command = sb.append("pm ").append("disable ").append(deployment.getApplicationBasePackage()).toString();
        try {
            Monkey monkey = new Monkey(DroidiumFileUtils.createRandomEmptyFile(this.sdk.getPlatformConfiguration().getTmpDir()), deployment.getApplicationBasePackage(), false);
            this.device.executeShellCommand(command.toString(), (AndroidDeviceOutputReciever)monkey);
            Monkey.wait(this.device, monkey, TOP_CMD);
        }
        catch (IOException e) {
            throw new AndroidExecutionException("Unable to disable running application " + deployment.getApplicationBasePackage());
        }
    }

    public AndroidApplicationManager setDevice(AndroidDevice device) {
        this.device = device;
        return this;
    }
}

