/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceRegister;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.spi.event.AndroidContainerStop;
import org.arquillian.droidium.container.spi.event.AndroidEmulatorShuttedDown;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceDelete;
import org.arquillian.droidium.container.task.EmulatorShutdownTask;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.execution.CountDownWatch;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidEmulatorShutdown {
    private static final Logger logger = Logger.getLogger(AndroidEmulatorShutdown.class.getName());
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidDevice> androidDevice;
    @Inject
    private Instance<AndroidDeviceRegister> androidDeviceRegister;
    @Inject
    private Event<AndroidEmulatorShuttedDown> androidEmulatorShuttedDown;
    @Inject
    private Event<AndroidVirtualDeviceDelete> androidVirtualDeviceDelete;

    public void shutdownEmulator(@Observes AndroidContainerStop event) throws AndroidExecutionException {
        AndroidDevice device = (AndroidDevice)this.androidDevice.get();
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        ((AndroidDeviceRegister)this.androidDeviceRegister.get()).remove(device);
        if (device != null && device.isEmulator() && !device.getAlreadyRuns()) {
            logger.log(Level.INFO, "Stopping Android emulator of AVD name {0}.", configuration.getAvdName());
            CountDownWatch countdown = new CountDownWatch(configuration.getEmulatorShutdownTimeoutInSeconds(), TimeUnit.SECONDS);
            logger.info("Waiting " + countdown.timeout() + " seconds for emulator " + device.getAvdName() + " to be disconnected and shutdown.");
            ((EmulatorShutdownTask)Spacelift.task((Object)device, EmulatorShutdownTask.class)).countdown(countdown).execute().await();
            logger.info("Device " + device.getAvdName() + " on port " + device.getConsolePort() + " was disconnected in " + countdown.timeElapsed() + " seconds.");
            if (configuration.isAVDGenerated()) {
                this.androidVirtualDeviceDelete.fire((Object)new AndroidVirtualDeviceDelete());
            }
            this.androidEmulatorShuttedDown.fire((Object)new AndroidEmulatorShuttedDown(device));
        }
    }
}

