/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import com.android.ddmlib.AndroidDebugBridge;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidBridge;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.impl.DeviceDiscovery;
import org.arquillian.droidium.container.spi.event.AndroidDeviceReady;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceAvailable;
import org.arquillian.droidium.container.task.EmulatorIsOnlineTask;
import org.arquillian.droidium.container.task.EmulatorStatusCheckTask;
import org.arquillian.droidium.container.task.FreePortTask;
import org.arquillian.droidium.container.task.UnlockEmulatorTask;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.execution.CountDownWatch;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessInteractionBuilder;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.task.os.CommandTool;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.threading.ExecutorService;

public class AndroidEmulatorStartup {
    private static final Logger logger = Logger.getLogger(AndroidEmulatorStartup.class.getName());
    @Inject
    @ContainerScoped
    private InstanceProducer<AndroidDevice> androidDevice;
    @Inject
    private Instance<AndroidBridge> androidBridge;
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Event<AndroidDeviceReady> androidDeviceReady;
    @Inject
    private Instance<ExecutorService> executorService;

    public void startAndroidEmulator(@Observes AndroidVirtualDeviceAvailable event) throws AndroidExecutionException {
        if (!((AndroidBridge)this.androidBridge.get()).isConnected()) {
            throw new IllegalStateException("Android debug bridge must be connected in order to spawn an emulator");
        }
        logger.log(Level.INFO, "Starting Android emulator of AVD name {0}.", ((AndroidContainerConfiguration)this.configuration.get()).getAvdName());
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        AndroidSDK sdk = (AndroidSDK)this.androidSDK.get();
        DeviceDiscovery deviceDiscovery = new DeviceDiscovery();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceDiscovery);
        Execution<ProcessResult> emulatorExecution = this.startEmulator();
        CountDownWatch watch = new CountDownWatch(configuration.getEmulatorBootupTimeoutInSeconds(), TimeUnit.SECONDS);
        ((EmulatorIsOnlineTask)Spacelift.task((Object)deviceDiscovery, EmulatorIsOnlineTask.class)).execute().until(watch, EmulatorIsOnlineTask.isOnlineCondition);
        AndroidDevice androidDevice = deviceDiscovery.getDevice();
        ((CommandTool)((EmulatorStatusCheckTask)Spacelift.task(EmulatorStatusCheckTask.class)).execution(emulatorExecution).then(CommandTool.class)).addEnvironment(sdk.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).command(new CommandBuilder((CharSequence)((AndroidSDK)this.androidSDK.get()).getAdbPath()).parameters(new CharSequence[]{"-s", androidDevice.getSerialNumber(), "shell", "getprop"})).execute().until(watch, EmulatorStatusCheckTask.isBootedCondition);
        ((UnlockEmulatorTask)Spacelift.task(UnlockEmulatorTask.class)).serialNumber(androidDevice.getSerialNumber()).sdk(sdk).execute().await();
        androidDevice.setDroneHostPort(configuration.getDroneHostPort());
        androidDevice.setDroneGuestPort(configuration.getDroneGuestPort());
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceDiscovery);
        this.androidDevice.set((Object)androidDevice);
        this.androidDeviceReady.fire((Object)new AndroidDeviceReady(androidDevice));
    }

    private Execution<ProcessResult> startEmulator() throws AndroidExecutionException {
        AndroidSDK sdk = (AndroidSDK)this.androidSDK.get();
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        CommandBuilder command = new CommandBuilder((CharSequence)sdk.getEmulatorPath());
        command.parameter((CharSequence)"-avd").parameter((CharSequence)configuration.getAvdName());
        if (configuration.getSdCard() != null) {
            command.parameters(new CharSequence[]{"-sdcard", configuration.getSdCard()});
        }
        if (configuration.getConsolePort() != null && !((Boolean)((FreePortTask)Spacelift.task(FreePortTask.class)).port(configuration.getConsolePort()).execute().await()).booleanValue()) {
            throw new AndroidExecutionException("It seems there is already something which listens on specified console port " + configuration.getConsolePort() + " so Droidium can not start emulator there.");
        }
        if (configuration.getAdbPort() != null && !((Boolean)((FreePortTask)Spacelift.task(FreePortTask.class)).port(configuration.getAdbPort()).execute().await()).booleanValue()) {
            throw new AndroidExecutionException("It seems there is already something which listens on specified adb port " + configuration.getAdbPort() + " so Droidium can not start emulator there.");
        }
        if (configuration.getConsolePort() != null && configuration.getAdbPort() != null) {
            command.parameter((CharSequence)"-ports").parameter((CharSequence)(configuration.getConsolePort() + "," + configuration.getAdbPort()));
        } else if (configuration.getConsolePort() != null) {
            command.parameter((CharSequence)"-port").parameter((CharSequence)configuration.getConsolePort());
        }
        command.splitToParameters((CharSequence)configuration.getEmulatorOptions());
        logger.log(Level.INFO, "Starting emulator \"{0}\", using {1}", new Object[]{configuration.getAvdName(), command});
        ProcessInteractionBuilder interactions = new ProcessInteractionBuilder().when("^SDL init failure.*$").printToErr().when("^PANIC:.*$").printToErr().when("^error.*$").printToErr().when("^unknown option:.*$").printToErr();
        try {
            return ((CommandTool)Spacelift.task(CommandTool.class)).addEnvironment(sdk.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).command(command).interaction(interactions.build()).execute();
        }
        catch (ExecutionException ex) {
            throw new AndroidExecutionException((Throwable)ex, "Unable to start emulator \"{0}\", using {1}", new Object[]{configuration.getAvdName(), command});
        }
    }
}

