/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.api.AndroidSDCardManager;
import org.arquillian.droidium.container.api.FileType;
import org.arquillian.droidium.container.api.IdentifierGenerator;
import org.arquillian.droidium.container.api.IdentifierType;
import org.arquillian.droidium.container.api.SDCard;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.impl.AndroidSDCard;
import org.arquillian.droidium.container.spi.event.AndroidSDCardCreate;
import org.arquillian.droidium.container.spi.event.AndroidSDCardCreated;
import org.arquillian.droidium.container.spi.event.AndroidSDCardDelete;
import org.arquillian.droidium.container.spi.event.AndroidSDCardDeleted;
import org.arquillian.droidium.platform.impl.DroidiumPlatformConfiguration;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.task.os.CommandTool;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidSDCardManagerImpl
implements AndroidSDCardManager {
    private static final Logger logger = Logger.getLogger(AndroidSDCardManagerImpl.class.getName());
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<DroidiumPlatformConfiguration> droidiumPlatformConfiguration;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<IdentifierGenerator<FileType>> idGenerator;
    @Inject
    private Event<AndroidSDCardCreated> androidSDCardCreated;
    @Inject
    private Event<AndroidSDCardDeleted> androidSDCardDeleted;

    public void createSDCard(@Observes AndroidSDCardCreate event) throws AndroidExecutionException {
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        AndroidSDCard sdCard = new AndroidSDCard();
        sdCard.setFileName(configuration.getSdCard());
        sdCard.setGenerated(configuration.getGenerateSDCard());
        sdCard.setLabel(configuration.getSdCardLabel());
        sdCard.setSize(configuration.getSdSize());
        if (sdCard.getLabel() == null) {
            String sdCardLabel = ((IdentifierGenerator)this.idGenerator.get()).getIdentifier((IdentifierType)FileType.SD_CARD_LABEL);
            sdCard.setLabel(sdCardLabel);
        }
        if (sdCard.isGenerated()) {
            if (sdCard.getFileName() == null) {
                String sdCardName = new File(((DroidiumPlatformConfiguration)this.droidiumPlatformConfiguration.get()).getTmpDir(), ((IdentifierGenerator)this.idGenerator.get()).getIdentifier((IdentifierType)FileType.SD_CARD)).getAbsolutePath();
                sdCard.setFileName(sdCardName);
                configuration.setSdCard(sdCardName);
                this.createSDCard(sdCard);
                this.androidSDCardCreated.fire((Object)new AndroidSDCardCreated());
            } else if (new File(sdCard.getFileName()).exists()) {
                configuration.setGenerateSDCard(false);
                sdCard.setGenerated(false);
            } else {
                this.createSDCard(sdCard);
                this.androidSDCardCreated.fire((Object)new AndroidSDCardCreated());
            }
        } else if (sdCard.getFileName() != null) {
            if (new File(sdCard.getFileName()).exists()) {
                logger.log(Level.INFO, "Using SD card at " + sdCard.getFileName());
            } else {
                logger.log(Level.INFO, "SD card you specified does not exist (" + sdCard.getFileName() + ") and its " + "generation is set to false. Default system SD card for Android emulator will be used.");
            }
        }
    }

    public void deleteSDCard(@Observes AndroidSDCardDelete event) {
        AndroidSDCard sdCard = new AndroidSDCard();
        sdCard.setFileName(((AndroidContainerConfiguration)this.configuration.get()).getSdCard());
        sdCard.setGenerated(((AndroidContainerConfiguration)this.configuration.get()).getGenerateSDCard());
        try {
            if (sdCard.getFileName() != null && sdCard.isGenerated()) {
                this.deleteSDCard(sdCard);
                this.androidSDCardDeleted.fire((Object)new AndroidSDCardDeleted());
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Unable to delete SD card", e);
        }
    }

    public void deleteSDCard(SDCard sdCard) {
        AndroidSDCard androidSdCard = (AndroidSDCard)sdCard;
        if (androidSdCard.getFileName() != null && androidSdCard.isGenerated()) {
            if (new File(androidSdCard.getFileName()).delete()) {
                logger.log(Level.INFO, "Android SD card labelled {0} located at {1} was deleted", new Object[]{androidSdCard.getLabel(), androidSdCard.getFileName()});
            } else {
                logger.log(Level.INFO, "Unable to delete android SD card labelled {0} located at {1}.", new Object[]{androidSdCard.getLabel(), androidSdCard.getFileName()});
            }
        }
    }

    public void createSDCard(SDCard sdCard) throws AndroidExecutionException {
        AndroidSDCard androidSDCard = (AndroidSDCard)sdCard;
        AndroidSDK sdk = (AndroidSDK)this.androidSDK.get();
        Command command = new CommandBuilder((CharSequence)sdk.getMakeSdCardPath()).parameter((CharSequence)"-l").parameter((CharSequence)androidSDCard.getLabel()).parameter((CharSequence)androidSDCard.getSize()).parameter((CharSequence)androidSDCard.getFileName()).build();
        try {
            ((CommandTool)Spacelift.task(CommandTool.class)).addEnvironment(((AndroidSDK)this.androidSDK.get()).getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).command(command).execute().await();
        }
        catch (ExecutionException ex) {
            throw new AndroidExecutionException("Unable to create SD card", (Throwable)ex);
        }
        logger.log(Level.INFO, "Android SD card labelled {0} located at {1} with size of {2} was created.", new Object[]{androidSDCard.getLabel(), androidSDCard.getFileName(), androidSDCard.getSize()});
    }
}

