/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.os.CommandTool;

public class AndroidKillTask
extends Task<Integer, ProcessResult> {
    private static final Logger logger = Logger.getLogger(AndroidKillTask.class.getName());
    private AndroidSDK androidSdk;
    private int signum = 9;

    public AndroidKillTask androidSdk(AndroidSDK androidSdk) {
        Validate.notNull(androidSdk, "Android Sdk is null object.");
        this.androidSdk = androidSdk;
        return this;
    }

    public AndroidKillTask signum(int signum) {
        if (signum > 0) {
            this.signum = signum;
        } else {
            logger.log(Level.INFO, String.format("Given signal number '%s' is lower then 0 and will be ignored.", signum));
        }
        return this;
    }

    public AndroidKillTask signum(String signum) {
        Validate.notNullOrEmpty(signum, "Signal number is a null object or an empty string!");
        try {
            this.signum(Integer.parseInt(signum));
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, String.format("Unable to convert given signal number '%s' into a number.", signum));
        }
        return this;
    }

    protected ProcessResult process(Integer pid) throws Exception {
        Validate.notNull(pid, "PID for process to kill is a null object!");
        Validate.notNull(this.androidSdk, "Android SDK is a null object!");
        if (pid <= 0) {
            throw new IllegalStateException("PID to kill is lower then 0.");
        }
        ProcessResult processResult = (ProcessResult)((CommandTool)Spacelift.task(CommandTool.class)).programName((CharSequence)this.androidSdk.getAdbPath()).addEnvironment(this.androidSdk.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).parameters(new CharSequence[]{"shell", "kill", "-" + this.signum, pid.toString()}).execute().await();
        return processResult;
    }
}

