/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.activity;

import org.arquillian.droidium.container.api.ActivityManager;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.jboss.arquillian.core.spi.Validate;

public class DefaultActivityManager
implements ActivityManager {
    private AndroidDevice device;

    public DefaultActivityManager() {
    }

    public DefaultActivityManager(AndroidDevice device) {
        Validate.notNull((Object)device, (String)"Android device via which you want to manage activies can not be a null object!");
        this.device = device;
    }

    public void startActivity(String activity) {
        Validate.notNullOrEmpty((String)activity, (String)"Activity you want to start can not be a null object nor an empty string!");
        this.device.executeShellCommand("am start -n " + DefaultActivityManager.getActivityComponent(activity));
    }

    public void startActivity(Class<?> activity) {
        Validate.notNull(activity, (String)"Activity you want to start can not be a null object!");
        this.startActivity(activity.getName());
    }

    public void stopActivity(String activity) {
        Validate.notNullOrEmpty((String)activity, (String)"Activity you want to stop can not be a null object nor an empty string!");
        if (!activity.contains(".")) {
            throw new IllegalArgumentException("Stopping of activity equals to killing the package it belongs to. It seems you have not specified FQDN of activity you want to stop so package name can not be extracted from it.");
        }
        this.device.executeShellCommand("am kill " + activity.substring(0, activity.lastIndexOf(".")));
    }

    public void stopActivity(Class<?> activity) {
        Validate.notNull(activity, (String)"Activity you want to stop can not be a null object!");
        this.stopActivity(activity.getName().substring(0, activity.getName().lastIndexOf(".")));
    }

    public static String getActivityComponent(String activity) {
        if (activity.matches("([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*/([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*")) {
            return activity;
        }
        if (activity.matches("([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*/\\.\\w+")) {
            return activity;
        }
        if (activity.matches("([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*") && activity.contains(".")) {
            return activity.substring(0, activity.lastIndexOf(".")) + "/." + activity.substring(activity.lastIndexOf(".") + 1);
        }
        throw new IllegalArgumentException("Unable to get activity to operate upon from '" + activity + "'. Please enter activity like some.package.name.SomeActivity or some.package.name/.SomeActivity " + "or some.package/some.other.package.Activity");
    }
}

