/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.util.Map;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.SecurityActions;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.container.spi.event.container.BeforeStart;
import org.jboss.arquillian.core.api.annotation.Observes;

public class DroidiumExtensionsValidation {
    private static final Logger logger = Logger.getLogger(DroidiumExtensionsValidation.class.getName());

    public void validateDescriptor(@Observes BeforeStart event, ArquillianDescriptor descriptor) {
        if (!event.getDeployableContainer().getConfigurationClass().equals(AndroidContainerConfiguration.class)) {
            return;
        }
        Map extensionProperties = null;
        for (ExtensionDef extension : descriptor.getExtensions()) {
            String browser;
            extensionProperties = extension.getExtensionProperties();
            if (!extension.getExtensionName().startsWith("webdriver") || (browser = (String)extensionProperties.get("browser")) == null || !browser.equals("android") || this.isNativeExtensionOnClassPath()) continue;
            logger.warning("You have Droidium container as well as webdriver extension with browser \"android\" configured in arquillian.xml but there is not Droidium native extension on the class path. This setting is highly suspicious - it might not be wrong when you actually do not use Drone instance injected into test case for that extension however, in most cases, please add Droidium native on class path to be able to test native Android applications or web applications from Android device.");
            break;
        }
    }

    private boolean isNativeExtensionOnClassPath() {
        return SecurityActions.isClassPresent("org.arquillian.droidium.native_.DroidiumNativeExtension");
    }
}

