/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration.target;

import org.arquillian.droidium.container.configuration.target.ABI;
import org.arquillian.droidium.container.configuration.target.TAG;

public class TagAbiPair
implements Comparable<TagAbiPair> {
    private TAG tag = TAG.NOT_DEFINED;
    private ABI abi = ABI.NOT_DEFINED;

    public TagAbiPair(TAG tag, ABI abi) {
        if (tag != null) {
            this.tag = tag;
        }
        if (abi != null) {
            this.abi = abi;
        }
    }

    public TAG getTag() {
        return this.tag;
    }

    public ABI getAbi() {
        return this.abi;
    }

    public String toString() {
        return this.tag.toString() + "/" + this.abi.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.abi == null ? 0 : this.abi.hashCode());
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagAbiPair other = (TagAbiPair)obj;
        if (this.tag != other.tag) {
            return false;
        }
        return this.abi == other.abi;
    }

    public static TagAbiPair construct(String tagAbiString) {
        if (tagAbiString == null || tagAbiString.isEmpty()) {
            return null;
        }
        String[] pair = tagAbiString.split("/");
        if (pair.length != 2) {
            return null;
        }
        TAG tag = TAG.match(pair[0]);
        ABI abi = ABI.match(pair[1]);
        TagAbiPair tagAbiPair = new TagAbiPair(tag, abi);
        return tagAbiPair;
    }

    @Override
    public int compareTo(TagAbiPair o) {
        if (o == null) {
            return 1;
        }
        int comparision = this.tag.ordinal() - o.tag.ordinal();
        if (comparision == 0) {
            comparision = this.abi.ordinal() - o.abi.ordinal();
        }
        return comparision;
    }
}

