/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration.target;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.arquillian.droidium.container.configuration.target.ABI;
import org.arquillian.droidium.container.configuration.target.TAG;
import org.arquillian.droidium.container.configuration.target.TARGET_TYPE;
import org.arquillian.droidium.container.configuration.target.TagAbiPair;

public class Target
implements Comparable<Target> {
    private int id = 0;
    private String idLabel;
    private int apiLevel;
    private String name;
    private TARGET_TYPE targetType;
    private String vendor;
    private int revision;
    private String description;
    private List<String> skins = new ArrayList<String>();
    private List<TagAbiPair> tagAbiPairs = new ArrayList<TagAbiPair>();

    public Target() {
    }

    public Target(TAG tag, ABI abi) {
        this.addTagAbi(tag, abi);
    }

    public void setId(int id) {
        if (id > 0) {
            this.id = id;
        }
    }

    public int getId() {
        return this.id;
    }

    public void setIdLabel(String idLabel) {
        if (idLabel != null && !idLabel.isEmpty()) {
            this.idLabel = idLabel;
        }
    }

    public String getIdLabel() {
        return this.idLabel;
    }

    public int getApiLevel() {
        return this.apiLevel;
    }

    public void setApiLevel(int apiLevel) {
        if (apiLevel > 0) {
            this.apiLevel = apiLevel;
        }
    }

    public void setName(String name) {
        if (name != null && !name.isEmpty()) {
            this.name = name;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setTargetType(TARGET_TYPE targetType) {
        if (targetType != null) {
            this.targetType = targetType;
        }
    }

    public TARGET_TYPE getTargetType() {
        return this.targetType;
    }

    public boolean isAddOn() {
        return TARGET_TYPE.ADD_ON.equals((Object)this.targetType);
    }

    public boolean isPlatorm() {
        return TARGET_TYPE.PLATFORM.equals((Object)this.targetType);
    }

    public void setVendor(String vendor) {
        if (vendor != null && !vendor.isEmpty()) {
            this.vendor = vendor;
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setRevision(int revision) {
        if (revision > 0) {
            this.revision = revision;
        }
    }

    public int getRevision() {
        return this.revision;
    }

    public void setDescription(String description) {
        if (description != null && !description.isEmpty()) {
            this.description = description;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void addSkin(String skin) {
        if (skin != null && !skin.isEmpty() && !this.skins.contains(skin)) {
            this.skins.add(skin);
        }
    }

    public void addSkins(List<String> skins) {
        if (skins != null) {
            for (String skin : skins) {
                this.addSkin(skin);
            }
        }
    }

    public List<String> getSkins() {
        return Collections.unmodifiableList(this.skins);
    }

    public boolean hasSkin(String skin) {
        if (skin == null || skin.isEmpty()) {
            return false;
        }
        return this.skins.contains(skin);
    }

    public List<TagAbiPair> getAbis() {
        return Collections.unmodifiableList(this.tagAbiPairs);
    }

    public String getDefaultSkin() {
        for (String skin : this.skins) {
            if (!skin.contains("(default)")) continue;
            return skin.split(" ")[0];
        }
        return null;
    }

    public void addTagAbi(String tagAbi) {
        this.addTagAbi(TagAbiPair.construct(tagAbi));
    }

    public void addTagAbi(String tag, String abi) {
        this.addTagAbi(TAG.match(tag), ABI.match(abi));
    }

    public void addTagAbi(TAG tag, ABI abi) {
        if (tag == null || abi == null) {
            return;
        }
        this.addTagAbi(new TagAbiPair(tag, abi));
    }

    public void addTagAbi(TagAbiPair abi) {
        if (abi != null) {
            this.tagAbiPairs.add(abi);
        }
    }

    public void addTagAbis(List<TagAbiPair> abis) {
        if (abis != null) {
            for (TagAbiPair abi : abis) {
                this.addTagAbi(abi);
            }
        }
    }

    public boolean hasTagAbis() {
        return !this.tagAbiPairs.isEmpty();
    }

    public boolean hasAbi(ABI abi) {
        if (abi == null) {
            return false;
        }
        for (TagAbiPair tagAbiPair : this.tagAbiPairs) {
            if (!tagAbiPair.getAbi().equals((Object)abi)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTag(TAG tag) {
        if (tag == null) {
            return false;
        }
        for (TagAbiPair tagAbiPair : this.tagAbiPairs) {
            if (!tagAbiPair.getTag().equals((Object)tag)) continue;
            return true;
        }
        return false;
    }

    public List<TagAbiPair> getTagAbisForTag(TAG tag) {
        ArrayList<TagAbiPair> abis = new ArrayList<TagAbiPair>();
        if (tag != null) {
            for (TagAbiPair tagAbiPair : this.tagAbiPairs) {
                if (!tagAbiPair.getTag().equals((Object)tag)) continue;
                abis.add(tagAbiPair);
            }
        }
        return abis;
    }

    public List<TagAbiPair> getTagAbisForAbi(ABI abi) {
        ArrayList<TagAbiPair> abis = new ArrayList<TagAbiPair>();
        if (abi != null) {
            for (TagAbiPair tagAbiPair : this.tagAbiPairs) {
                if (!tagAbiPair.getAbi().equals((Object)abi)) continue;
                abis.add(tagAbiPair);
            }
        }
        return abis;
    }

    public boolean hasTagAbi(TAG tag, ABI abi) {
        return this.hasTagAbi(new TagAbiPair(tag, abi));
    }

    public boolean hasTagAbi(TagAbiPair tagAbiPair) {
        if (tagAbiPair == null) {
            return false;
        }
        for (TagAbiPair tap : this.tagAbiPairs) {
            if (!tagAbiPair.equals(tap)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTagAbi(String tag, String abi) {
        return this.hasTagAbi(TAG.match(tag), ABI.match(abi));
    }

    public boolean hasTagAbi(String tagAbi) {
        return this.hasTagAbi(TagAbiPair.construct(tagAbi));
    }

    public List<TagAbiPair> getDefaultAbis() {
        ArrayList<TagAbiPair> abis = new ArrayList<TagAbiPair>();
        for (TagAbiPair abi : this.tagAbiPairs) {
            if (!abi.getTag().equals((Object)TAG.DEFAULT)) continue;
            abis.add(abi);
        }
        return abis;
    }

    public int numberOfTagAbis() {
        return this.tagAbiPairs.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Target [id = ").append(this.id).append(", idLabel= " + this.idLabel).append(", apiLevel=").append(this.apiLevel).append(", name=").append(this.name).append(", revision=").append(this.revision);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.apiLevel;
        result = 31 * result + this.id;
        result = 31 * result + (this.idLabel == null ? 0 : this.idLabel.hashCode());
        result = 31 * result + this.revision;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Target other = (Target)obj;
        if (this.apiLevel != other.apiLevel) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.idLabel == null ? other.idLabel != null : !this.idLabel.equals(other.idLabel)) {
            return false;
        }
        return this.revision == other.revision;
    }

    @Override
    public int compareTo(Target o) {
        if (o == null) {
            return 1;
        }
        return this.getId() - o.getId();
    }
}

