/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration.target;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.arquillian.droidium.container.configuration.target.ABI;
import org.arquillian.droidium.container.configuration.target.TAG;
import org.arquillian.droidium.container.configuration.target.TARGET_TYPE;
import org.arquillian.droidium.container.configuration.target.TagAbiPair;
import org.arquillian.droidium.container.configuration.target.Target;

public class TargetRegistry {
    private final List<Target> targets = new ArrayList<Target>();

    public void addTarget(Target target) {
        if (target == null) {
            return;
        }
        this.targets.add(target);
    }

    public void addTargets(List<Target> targets) {
        for (Target target : targets) {
            this.addTarget(target);
        }
    }

    public List<Target> getTargets() {
        return Collections.unmodifiableList(this.targets);
    }

    public void clear() {
        this.targets.clear();
    }

    public List<Target> getTargetsWithNoAbis() {
        ArrayList<Target> targets = new ArrayList<Target>();
        for (Target target : this.targets) {
            if (target.numberOfTagAbis() != 0) continue;
            targets.add(target);
        }
        return targets;
    }

    public List<Target> getByTag(TAG tag) {
        ArrayList<Target> targets = new ArrayList<Target>();
        for (Target target : this.targets) {
            if (!target.hasTag(tag)) continue;
            targets.add(target);
        }
        return targets;
    }

    public List<Target> getByABI(ABI abi) {
        ArrayList<Target> targets = new ArrayList<Target>();
        for (Target target : this.targets) {
            if (!target.hasAbi(abi)) continue;
            targets.add(target);
        }
        return targets;
    }

    public List<Target> getByPair(TagAbiPair tagAbiPair) {
        ArrayList<Target> targets = new ArrayList<Target>();
        for (Target target : this.targets) {
            if (!target.hasTagAbi(tagAbiPair)) continue;
            targets.add(target);
        }
        return targets;
    }

    public List<Target> getByPair(TAG tag, ABI abi) {
        return this.getByPair(new TagAbiPair(tag, abi));
    }

    public Target getByIdLabel(String idLabel) {
        if (idLabel == null || idLabel.isEmpty()) {
            return null;
        }
        for (Target target : this.targets) {
            if (!target.getIdLabel().equals(idLabel)) continue;
            return target;
        }
        return null;
    }

    public List<Target> getByApiLevel(int apiLevel) {
        ArrayList<Target> foundTargets = new ArrayList<Target>();
        for (Target target : this.targets) {
            if (target.getApiLevel() != apiLevel) continue;
            foundTargets.add(target);
        }
        return foundTargets;
    }

    public List<Target> getByApiLevel(String apiLevel) {
        return this.getByApiLevel(Integer.parseInt(apiLevel));
    }

    public List<Target> getAddOns() {
        ArrayList<Target> addons = new ArrayList<Target>();
        for (Target target : this.targets) {
            if (!target.isAddOn()) continue;
            addons.add(target);
        }
        return addons;
    }

    public List<Target> getPlatforms() {
        ArrayList<Target> platforms = new ArrayList<Target>();
        for (Target target : this.targets) {
            if (!target.isPlatorm()) continue;
            platforms.add(target);
        }
        return platforms;
    }

    public List<Target> getByTargetType(TARGET_TYPE targetType) {
        ArrayList<Target> targets = new ArrayList<Target>();
        for (Target target : this.targets) {
            if (!target.getTargetType().equals((Object)targetType)) continue;
            targets.add(target);
        }
        return targets;
    }

    public Target getHighest(TARGET_TYPE targetType) {
        List<Target> targets = this.getByTargetType(targetType);
        Collections.sort(targets);
        if (targets.isEmpty()) {
            return null;
        }
        return targets.get(targets.size() - 1);
    }

    public Target getLowest(TARGET_TYPE targetType) {
        List<Target> targets = this.getByTargetType(targetType);
        Collections.sort(targets);
        if (targets.isEmpty()) {
            return null;
        }
        return targets.get(0);
    }
}

