/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.task.os.CommandTool;

public class AndroidApplicationHelper {
    private static final Logger logger = Logger.getLogger(AndroidApplicationHelper.class.getName());
    private final AndroidSDK sdk;

    public AndroidApplicationHelper(AndroidSDK sdk) {
        Validate.notNull(sdk, "Android SDK to set can not be a null object!");
        this.sdk = sdk;
    }

    public String getApplicationMainActivity(File apk) {
        return this.getAAPTBadgingOutput(apk).getSingleProperty("launchable-activity", "name");
    }

    public String getApplicationMainActivity(String apk) {
        return this.getApplicationMainActivity(new File(apk));
    }

    public String getApplicationBasePackage(File apk) {
        return this.getAAPTBadgingOutput(apk).getSingleProperty("package", "name");
    }

    public String getApplicationVersion(File apk) {
        return this.getAAPTBadgingOutput(apk).getSingleProperty("package", "versionName");
    }

    public List<String> getActivities(File apk) {
        ArrayList<String> activities = new ArrayList();
        try {
            activities = this.filterActivities(this.getAAPTXmlTreeOutput(apk));
        }
        catch (AndroidExecutionException e) {
            logger.log(Level.SEVERE, "Unable to get list of activities for file: " + apk.getAbsolutePath(), e);
        }
        return activities;
    }

    public List<String> getActivities(String apkFile) {
        return this.getActivities(new File(apkFile));
    }

    public String getApplicationBasePackage(String apk) {
        return this.getApplicationBasePackage(new File(apk));
    }

    private BadgingOutput getAAPTBadgingOutput(File apk) {
        Command command = new CommandBuilder((CharSequence)this.sdk.getAaptPath()).parameter((CharSequence)"dump").parameter((CharSequence)"badging").parameter((CharSequence)apk.getAbsolutePath()).build();
        return new BadgingOutput(((ProcessResult)((CommandTool)Spacelift.task(CommandTool.class)).addEnvironment(this.sdk.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).command(command).execute().await()).output());
    }

    private List<String> getAAPTXmlTreeOutput(File apkFile) {
        Command command = new CommandBuilder((CharSequence)this.sdk.getAaptPath()).parameter((CharSequence)"dump").parameter((CharSequence)"xmltree").parameter((CharSequence)apkFile.getAbsolutePath()).parameter((CharSequence)"AndroidManifest.xml").build();
        return ((ProcessResult)((CommandTool)Spacelift.task(CommandTool.class)).addEnvironment(this.sdk.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).command(command).execute().await()).output();
    }

    private List<String> filterActivities(List<String> output) {
        ArrayList<String> activities = new ArrayList<String>();
        String packageName = this.getPackageName(output);
        for (int i = 0; i < output.size(); ++i) {
            if (!output.get(i).trim().startsWith("E: activity")) continue;
            while (!output.get(++i).trim().contains("A: android:name")) {
            }
            String activityName = this.getActivityName(output.get(i));
            if (activityName.startsWith(".")) {
                activities.add(packageName + activityName);
                continue;
            }
            if (!activityName.startsWith(".") && !activityName.contains(".")) {
                activities.add(packageName + "." + activityName);
                continue;
            }
            activities.add(activityName);
        }
        return activities;
    }

    private String getPackageName(List<String> output) {
        for (String line : output) {
            Pattern packagePattern;
            Matcher m;
            if (!line.contains("package") || !(m = (packagePattern = Pattern.compile("package=['\"]([^'\"]+)['\"]")).matcher(line)).find()) continue;
            return m.group(1);
        }
        throw new IllegalStateException("no package name found in dump xmltree for AndroidManifest.xml");
    }

    private String getActivityName(String line) {
        Pattern activityPattern = Pattern.compile("=[\"]([^\"]+)[\"]");
        Matcher m = activityPattern.matcher(line);
        if (m.find()) {
            return m.group(1);
        }
        throw new IllegalStateException("no activity name found in AndroidManifest.xml on line: " + line);
    }

    static final class BadgingOutput {
        private final List<String> badgingOutput;

        public BadgingOutput(List<String> output) {
            this.badgingOutput = output;
        }

        public List<String> getProperty(String propertyName) {
            ArrayList<String> output = new ArrayList<String>();
            Pattern propertyPattern = Pattern.compile("^(\\s*)" + propertyName + "(:?)(.*)$");
            for (String line : this.badgingOutput) {
                Matcher m = propertyPattern.matcher(line);
                if (!m.find()) continue;
                output.add(m.group(3));
            }
            return output;
        }

        public List<String> getProperty(String propertyName, String propertySubName) {
            List<String> partialResults = this.getProperty(propertyName);
            ArrayList<String> output = new ArrayList<String>(partialResults.size());
            Pattern subPropertyPattern = Pattern.compile(propertySubName + "=['\"]([^'\"]+)['\"]");
            for (String line : partialResults) {
                Matcher m = subPropertyPattern.matcher(line);
                if (!m.find()) continue;
                output.add(m.group(1));
            }
            return output;
        }

        public String getSingleProperty(String propertyName) {
            List<String> output = this.getProperty(propertyName);
            if (output.size() > 0) {
                return output.iterator().next();
            }
            logger.log(Level.SEVERE, "Unable to get {0} from aapt output: {1}", new Object[]{propertyName, this.badgingOutput});
            return "";
        }

        public String getSingleProperty(String propertyName, String propertySubName) {
            List<String> output = this.getProperty(propertyName, propertySubName);
            if (output.size() > 0) {
                return output.iterator().next();
            }
            logger.log(Level.SEVERE, "Unable to get {0}:{1} from aapt output: {2}", new Object[]{propertyName, propertySubName, this.badgingOutput});
            return "";
        }
    }
}

