/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.ActivityManager;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceOutputReciever;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.api.ScreenrecordOptions;
import org.arquillian.droidium.container.api.Screenshot;
import org.arquillian.droidium.container.api.Video;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.impl.AndroidProcessRunningTask;
import org.arquillian.droidium.container.task.AndroidKillTask;
import org.arquillian.droidium.container.task.AndroidPidTask;
import org.arquillian.droidium.container.task.ScreenRecordToolBuilder;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionCondition;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.task.os.CommandTool;

public class AndroidDeviceImpl
implements AndroidDevice {
    private static final Logger log = Logger.getLogger(AndroidDeviceImpl.class.getName());
    private static final String RECORD_EXTENSION = ".mp4";
    private static final String RECORD_PREFIX = "droidium_record_";
    private static final String RECORD_DIRECTORY = "/sdcard/";
    private IDevice delegate;
    private AndroidSDK androidSdk;
    private ActivityManager activityManager;
    private int droneHostPort = 14444;
    private int droneGuestPort = 8080;
    private boolean alreadyRuns = false;
    private String recordedVideoRemote;
    private Execution<ProcessResult> screenrecorderExecution;

    public AndroidDeviceImpl() {
    }

    public AndroidDeviceImpl(IDevice delegate) {
        Validate.notNull(delegate, "delegate to set for Android device can not be a null object");
        this.delegate = delegate;
    }

    public AndroidDeviceImpl(IDevice delegate, AndroidSDK androidSdk) {
        Validate.notNull(delegate, "delegate to set for Android device can not be a null object");
        Validate.notNull(androidSdk, "AndroidSDK to set for Android device is a null object.");
        this.delegate = delegate;
        this.androidSdk = androidSdk;
    }

    public void setActivityManager(ActivityManager activityManager) {
        Validate.notNull(activityManager, "Activity manager to set for Android device can not be a null object!");
        this.activityManager = activityManager;
    }

    public ActivityManager getActivityManager() {
        return this.activityManager;
    }

    public String getSerialNumber() {
        return this.delegate.getSerialNumber();
    }

    public String getAvdName() {
        if (this.isEmulator()) {
            String avdName = this.delegate.getAvdName();
            if (avdName == null || avdName.equals("<build>")) {
                return null;
            }
            return avdName;
        }
        return null;
    }

    public String getProperty(String name) throws IOException, AndroidExecutionException {
        try {
            return (String)this.delegate.getSystemProperty(name).get();
        }
        catch (ExecutionException e) {
            throw new AndroidExecutionException("Unable to get property '" + name + "' value, not responsive", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new AndroidExecutionException("Unable to get property '" + name + "' value, not responsive", (Throwable)e);
        }
    }

    public boolean isOnline() {
        return this.delegate.isOnline();
    }

    public boolean isEmulator() {
        return this.delegate.isEmulator();
    }

    public boolean isOffline() {
        return this.delegate.isOffline();
    }

    public String getConsolePort() {
        return this.isEmulator() ? this.getSerialNumber().split("-")[1] : null;
    }

    public void executeShellCommand(final String command) throws AndroidExecutionException {
        this.executeShellCommand(command, new AndroidDeviceOutputReciever(){

            public void processNewLines(String[] lines) {
                if (log.isLoggable(Level.INFO)) {
                    for (String line : lines) {
                        log.log(Level.FINE, "Shell command {0}: {1}", new Object[]{command, line});
                    }
                }
            }

            public boolean isCancelled() {
                return false;
            }
        });
    }

    public void executeShellCommand(String command, AndroidDeviceOutputReciever reciever) throws AndroidExecutionException {
        try {
            this.delegate.executeShellCommand(command, (IShellOutputReceiver)new AndroidRecieverDelegate(reciever));
        }
        catch (TimeoutException e) {
            throw new AndroidExecutionException("Unable to execute command '" + command + "' within given timeout", (Throwable)e);
        }
        catch (AdbCommandRejectedException e) {
            throw new AndroidExecutionException("Unable to execute command '" + command + "', command was rejected", (Throwable)e);
        }
        catch (ShellCommandUnresponsiveException e) {
            throw new AndroidExecutionException("Unable to execute command '" + command + "', shell is not responsive", (Throwable)e);
        }
        catch (IOException e) {
            throw new AndroidExecutionException("Unable to execute command '" + command + "'", (Throwable)e);
        }
    }

    public void createPortForwarding(int localPort, int remotePort) throws AndroidExecutionException {
        try {
            this.delegate.createForward(localPort, remotePort);
        }
        catch (TimeoutException e) {
            throw new AndroidExecutionException("Unable to forward port (" + localPort + " to " + remotePort + ") within given timeout", (Throwable)e);
        }
        catch (AdbCommandRejectedException e) {
            throw new AndroidExecutionException("Unable to forward port (" + localPort + " to " + remotePort + "), command was rejected", (Throwable)e);
        }
        catch (IOException e) {
            throw new AndroidExecutionException("Unable to forward port (" + localPort + " to " + remotePort + ").", (Throwable)e);
        }
    }

    public void removePortForwarding(int localPort, int remotePort) throws AndroidExecutionException {
        try {
            this.delegate.removeForward(localPort, remotePort);
        }
        catch (TimeoutException e) {
            throw new AndroidExecutionException("Unable to remove port forwarding (" + localPort + " to " + remotePort + ") within given timeout", (Throwable)e);
        }
        catch (AdbCommandRejectedException e) {
            throw new AndroidExecutionException("Unable to remove port forwarding (" + localPort + " to " + remotePort + "), command was rejected", (Throwable)e);
        }
        catch (IOException e) {
            throw new AndroidExecutionException("Unable to remove port forwarding (" + localPort + " to " + remotePort + ").", (Throwable)e);
        }
    }

    public void installPackage(File packageFilePath, boolean reinstall, String ... extraArgs) throws AndroidExecutionException {
        if (!Validate.isReadable(packageFilePath.getAbsoluteFile())) {
            throw new IllegalArgumentException("File " + packageFilePath.getAbsoluteFile() + " must represent a readable APK file");
        }
        try {
            this.delegate.installPackage(packageFilePath.getAbsolutePath(), reinstall, extraArgs);
        }
        catch (InstallException e) {
            throw new AndroidExecutionException("Unable to install APK from " + packageFilePath.getAbsolutePath(), (Throwable)e);
        }
    }

    public void installPackage(String packageFilePath, boolean reinstall, String ... extraArgs) throws AndroidExecutionException {
        this.installPackage(new File(packageFilePath), reinstall, extraArgs);
    }

    public boolean isPackageInstalled(String packageName) throws AndroidExecutionException {
        try {
            String command = "pm list packages -f";
            PackageInstalledMonkey monkey = new PackageInstalledMonkey(packageName);
            this.executeShellCommand(command, monkey);
            return monkey.isInstalled();
        }
        catch (Exception e) {
            throw new AndroidExecutionException("Unable to decide if package " + packageName + " is installed or nor", (Throwable)e);
        }
    }

    public void uninstallPackage(String packageName) throws AndroidExecutionException {
        try {
            this.delegate.uninstallPackage(packageName);
        }
        catch (InstallException e) {
            throw new AndroidExecutionException("Unable to uninstall APK named " + packageName, (Throwable)e);
        }
    }

    public void pull(String remoteFilePath, String localFilePath) throws Exception {
        this.delegate.pullFile(remoteFilePath, localFilePath);
    }

    public void pull(File remoteFile, File localFile) throws Exception {
        this.delegate.pullFile(remoteFile.getAbsolutePath(), localFile.getAbsolutePath());
    }

    public void push(String localFilePath, String remoteFilePath) throws Exception {
        this.delegate.pushFile(localFilePath, remoteFilePath);
    }

    public void push(File localFile, File remoteFile) throws Exception {
        this.delegate.pushFile(localFile.getAbsolutePath(), remoteFile.getAbsolutePath());
    }

    public void remove(File remoteFile) throws Exception {
        this.executeShellCommand("rm " + remoteFile.getAbsolutePath());
    }

    public void remove(String remoteFilePath) throws Exception {
        this.remove(new File(remoteFilePath));
    }

    public void startRecording(ScreenrecordOptions options) throws Exception {
        this.startRecording("/sdcard/droidium_record_" + UUID.randomUUID().toString() + RECORD_EXTENSION, options);
    }

    public void startRecording(File remoteFilePath, ScreenrecordOptions options) throws Exception {
        this.startRecording(remoteFilePath.getAbsolutePath(), options);
    }

    public void startRecording(String remoteFilePath, ScreenrecordOptions options) throws Exception {
        if (this.isRecording()) {
            throw new IllegalStateException("Android device is already recording the video.");
        }
        Validate.notNullOrEmpty(remoteFilePath, "remoteFilePath for taken video is a null object");
        this.recordedVideoRemote = remoteFilePath;
        Validate.notNull(options, "options for recording of a video is a null object");
        CommandTool screenRecorderTool = new ScreenRecordToolBuilder().androidSdk(this.androidSdk).options(options).remoteFilePath(this.recordedVideoRemote).build();
        this.screenrecorderExecution = screenRecorderTool.execute();
    }

    public boolean isRecording() {
        return this.screenrecorderExecution != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Video stopRecording(String localFilePath) throws Exception {
        if (!this.isRecording()) {
            throw new IllegalStateException("Android device is not recording any video yet.");
        }
        Integer screenrecordPid = (Integer)((AndroidPidTask)Spacelift.task((Object)"screenrecord", AndroidPidTask.class)).androidSdk(this.androidSdk).execute().await();
        if (screenrecordPid > 0) {
            ((AndroidKillTask)Spacelift.task((Object)screenrecordPid, AndroidKillTask.class)).androidSdk(this.androidSdk).signum(2).execute().await();
            ((AndroidProcessRunningTask)Spacelift.task((Object)"screenrecord", AndroidProcessRunningTask.class)).androidSdk(this.androidSdk).execute().reexecuteEvery(1L, TimeUnit.SECONDS).until(60L, TimeUnit.SECONDS, (ExecutionCondition)new ExecutionCondition<Boolean>(){

                public boolean satisfiedBy(Boolean processRunning) {
                    return processRunning == false;
                }
            });
        }
        try {
            this.screenrecorderExecution.terminate();
        }
        catch (org.arquillian.spacelift.execution.ExecutionException ex) {
            log.log(Level.FINE, "Unable to terminate screenrecorder execution on host's side.");
        }
        finally {
            this.screenrecorderExecution = null;
        }
        this.pull(this.recordedVideoRemote, localFilePath);
        this.remove(this.recordedVideoRemote);
        VideoImpl video = new VideoImpl();
        video.setVideo(new File(localFilePath));
        return video;
    }

    public Video stopRecording(File localFilePath) throws Exception {
        return this.stopRecording(localFilePath.getAbsolutePath());
    }

    public int getDroneHostPort() {
        return this.droneHostPort;
    }

    public int getDroneGuestPort() {
        return this.droneGuestPort;
    }

    public void setDroneHostPort(int droneHostPort) {
        this.droneHostPort = droneHostPort;
    }

    public void setDroneGuestPort(int droneGuestPort) {
        this.droneGuestPort = droneGuestPort;
    }

    public Screenshot getScreenshot() throws Exception {
        ScreenshotImpl screenshot = new ScreenshotImpl();
        screenshot.setRawImage(this.delegate.getScreenshot());
        return screenshot;
    }

    public void setAlreadyRuns(boolean alreadyRuns) {
        this.alreadyRuns = alreadyRuns;
    }

    public boolean getAlreadyRuns() {
        return this.alreadyRuns;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-40s %s\n", "avdName", this.getAvdName()));
        sb.append(String.format("%-40s %s\n", "consolePort", this.getConsolePort()));
        sb.append(String.format("%-40s %s\n", "serialNumber", this.getSerialNumber()));
        sb.append(String.format("%-40s %s\n", "isEmulator", this.isEmulator()));
        sb.append(String.format("%-40s %s\n", "isOffline", this.isOffline()));
        sb.append(String.format("%-40s %s\n", "isOnline", this.isOnline()));
        sb.append(String.format("%-40s %s\n", "isRecording", this.isRecording()));
        sb.append(String.format("%-40s %s\n", "alreadyRuns", this.getAlreadyRuns()));
        sb.append(String.format("%-40s %s\n", "droneHostPort", this.getDroneHostPort()));
        sb.append(String.format("%-40s %s", "droneGuestPort", this.getDroneGuestPort()));
        return sb.toString();
    }

    private static final class AndroidRecieverDelegate
    extends MultiLineReceiver {
        private AndroidDeviceOutputReciever delegate;

        public AndroidRecieverDelegate(AndroidDeviceOutputReciever delegate) {
            this.delegate = delegate;
        }

        public void processNewLines(String[] lines) {
            this.delegate.processNewLines(lines);
        }

        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }
    }

    private static class PackageInstalledMonkey
    implements AndroidDeviceOutputReciever {
        private String packageName;
        private boolean installed = false;

        public PackageInstalledMonkey(String packageName) {
            this.packageName = packageName;
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                if (!line.contains(this.packageName)) continue;
                this.installed = true;
                break;
            }
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isInstalled() {
            return this.installed;
        }
    }

    private static class VideoImpl
    implements Video {
        File video;

        private VideoImpl() {
        }

        public void setVideo(File video) {
            this.video = video;
        }

        public File getVideo() {
            return this.video;
        }
    }

    private static class ScreenshotImpl
    implements Screenshot {
        RawImage screenshot;

        private ScreenshotImpl() {
        }

        public RawImage getRawImage() {
            return this.screenshot;
        }

        public void setRawImage(RawImage screenshot) {
            this.screenshot = screenshot;
        }
    }
}

