/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.util.List;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.os.CommandTool;

public class AndroidProcessRunningTask
extends Task<String, Boolean> {
    private AndroidSDK androidSdk;

    public AndroidProcessRunningTask androidSdk(AndroidSDK androidSdk) {
        Validate.notNull(androidSdk, "AndroidSDK is null object!");
        this.androidSdk = androidSdk;
        return this;
    }

    protected Boolean process(String processName) throws Exception {
        Validate.notNullOrEmpty(processName, "Process name to get running status of is a null object or it is an empty string!");
        Validate.notNull(this.androidSdk, "AndroidSDK is null object!");
        List psOutput = ((ProcessResult)((CommandTool)Spacelift.task(CommandTool.class)).programName((CharSequence)this.androidSdk.getAdbPath()).addEnvironment(this.androidSdk.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).parameter((CharSequence)"shell").parameter((CharSequence)"ps").execute().await()).output();
        boolean running = false;
        for (String outputLine : psOutput) {
            if (outputLine == null || !outputLine.trim().endsWith(processName)) continue;
            running = true;
            break;
        }
        return running;
    }
}

