/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.task;

import java.io.File;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.task.CheckKeyStoreTask;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.os.CommandTool;

public class APKSignerTask
extends Task<File, File> {
    protected AndroidSDK androidSDK;

    public APKSignerTask sdk(AndroidSDK androidSDK) {
        this.androidSDK = androidSDK;
        return this;
    }

    protected File process(File toSign) throws Exception {
        if (toSign == null || !toSign.exists()) {
            throw new IllegalStateException("File to be signed is either null or it does not exists");
        }
        ((CheckKeyStoreTask)Spacelift.task(CheckKeyStoreTask.class)).sdk(this.androidSDK).execute().await();
        File signed = new File(this.androidSDK.getPlatformConfiguration().getTmpDir(), DroidiumFileUtils.getRandomAPKFileName());
        Command jarSignerCommand = new CommandBuilder((CharSequence)this.androidSDK.getPathForJavaTool("jarsigner")).parameter((CharSequence)"-sigalg").parameter((CharSequence)"MD5withRSA").parameter((CharSequence)"-digestalg").parameter((CharSequence)"SHA1").parameter((CharSequence)"-signedjar").parameter((CharSequence)signed.getAbsolutePath()).parameter((CharSequence)"-storepass").parameter((CharSequence)this.androidSDK.getPlatformConfiguration().getStorepass()).parameter((CharSequence)"-keystore").parameter((CharSequence)new File(this.androidSDK.getPlatformConfiguration().getKeystore()).getAbsolutePath()).parameter((CharSequence)toSign.getAbsolutePath()).parameter((CharSequence)this.androidSDK.getPlatformConfiguration().getAlias()).build();
        ((CommandTool)Spacelift.task(CommandTool.class)).addEnvironment(this.androidSDK.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).command(jarSignerCommand).execute().await();
        return signed;
    }
}

