/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.containerless;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.arquillian.cube.impl.containerless.ContainerlessConfiguration;
import org.arquillian.cube.impl.containerless.IOUtil;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.CreateCube;
import org.arquillian.cube.spi.event.CubeControlEvent;
import org.arquillian.cube.spi.event.DestroyCube;
import org.arquillian.cube.spi.event.StartCube;
import org.arquillian.cube.spi.event.StopCube;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.exporter.TarExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class ContainerlessDockerDeployableContainer
implements DeployableContainer<ContainerlessConfiguration> {
    private static final String DOCKERFILE_TEMPLATE = "DockerfileTemplate";
    private static final Logger log = Logger.getLogger(ContainerlessDockerDeployableContainer.class.getName());
    private ContainerlessConfiguration configuration;
    @Inject
    private Instance<CubeRegistry> cubeRegistryInstance;
    @Inject
    private Event<CubeControlEvent> controlEvent;

    public Class<ContainerlessConfiguration> getConfigurationClass() {
        return ContainerlessConfiguration.class;
    }

    public void setup(ContainerlessConfiguration configuration) {
        this.configuration = configuration;
    }

    public void start() throws LifecycleException {
    }

    public void stop() throws LifecycleException {
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String containerlessDocker = this.configuration.getContainerlessDocker();
        CubeRegistry cubeRegistry = (CubeRegistry)this.cubeRegistryInstance.get();
        Cube cube = cubeRegistry.getCube(containerlessDocker);
        if (cube == null) {
            throw new IllegalArgumentException("No Containerless Docker container configured in extension with id " + containerlessDocker);
        }
        Map cubeConfiguration = cube.configuration();
        if (cubeConfiguration.containsKey("buildImage")) {
            Map<String, Object> params = ContainerlessDockerDeployableContainer.asMap(cubeConfiguration, "buildImage");
            if (params.containsKey("dockerfileLocation")) {
                File location = new File((String)params.get("dockerfileLocation"));
                if (location.isDirectory()) {
                    try {
                        this.createDockerfileFromTemplate(archive, location);
                        this.controlEvent.fire((Object)new CreateCube(cube));
                        this.controlEvent.fire((Object)new StartCube(cube));
                        return this.createProtocolMetadata(cube, archive);
                    }
                    catch (FileNotFoundException e) {
                        throw new IllegalArgumentException("Containerless Docker container requires a file named DockerfileTemplate");
                    }
                }
                throw new IllegalArgumentException("Dockerfile Template of containerless Docker container must be in a directory.");
            }
            throw new IllegalArgumentException("Containerless Docker container should be built in Dockerfile, and dockerfileLocation property not found.");
        }
        throw new IllegalArgumentException("Containerless Docker container should be built in Dockerfile, and buildImage property not found.");
    }

    private void createDockerfileFromTemplate(Archive<?> archive, File location) throws FileNotFoundException {
        File templateDockerfile = new File(location, DOCKERFILE_TEMPLATE);
        String deployableFilename = archive.getName();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("deployableFilename", deployableFilename);
        String templateContent = IOUtil.asStringPreservingNewLines(new FileInputStream(templateDockerfile));
        String dockerfileContent = IOUtil.replacePlaceholders(templateContent, values);
        File dockerfile = new File(location, "Dockerfile");
        if (dockerfile.exists()) {
            log.fine("Dockerfile file is already found in current build directory and is going to be renamed to Dockerfile.old.");
            dockerfile.renameTo(new File(location, "Dockerfile.old"));
            dockerfile = new File(location, "Dockerfile");
        }
        dockerfile.deleteOnExit();
        IOUtil.toFile(dockerfileContent, dockerfile);
        File deployableOutputFile = new File(location, deployableFilename);
        deployableOutputFile.deleteOnExit();
        if (archive instanceof GenericArchive) {
            ((TarExporter)archive.as(TarExporter.class)).exportTo(deployableOutputFile, true);
        } else {
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(deployableOutputFile, true);
        }
    }

    private ProtocolMetaData createProtocolMetadata(Cube cube, Archive<?> deployment) {
        Binding bindings = cube.bindings();
        HTTPContext httpContext = new HTTPContext(bindings.getIP(), this.configuration.getEmbeddedPort());
        if (this.containsArquillianServletProtocol(deployment)) {
            this.addArquillianTestServlet(deployment, httpContext);
        }
        return new ProtocolMetaData().addContext((Object)httpContext);
    }

    private boolean containsArquillianServletProtocol(Archive<?> deployment) {
        return deployment.getContent(Filters.include((String)".*arquillian-protocol.jar")).size() > 0;
    }

    private void addArquillianTestServlet(Archive<?> deployment, HTTPContext httpContext) {
        httpContext.add(new Servlet("ArquillianServletRunner", this.extractContextName(deployment)));
    }

    private String extractContextName(Archive<?> deployment) {
        String name = deployment.getName();
        name = name.substring(0, name.lastIndexOf("."));
        return name;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        String containerlessDocker = this.configuration.getContainerlessDocker();
        CubeRegistry cubeRegistry = (CubeRegistry)this.cubeRegistryInstance.get();
        Cube cube = cubeRegistry.getCube(containerlessDocker);
        if (cube != null) {
            this.controlEvent.fire((Object)new StopCube(cube));
            this.controlEvent.fire((Object)new DestroyCube(cube));
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static final Map<String, Object> asMap(Map<String, Object> map, String property) {
        return (Map)map.get(property);
    }
}

