/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.graphene.location;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import org.arquillian.cube.docker.drone.SeleniumContainers;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.util.SinglePortBindResolver;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.metadata.HasPortBindings;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class DockerCubeCustomizableURLResourceProvider
implements ResourceProvider {
    private static final int NO_PORT = -1;
    @Inject
    Instance<GrapheneConfiguration> grapheneConfiguration;
    @Inject
    Instance<CubeDockerConfiguration> cubeDockerConfigurationInstance;
    @Inject
    Instance<SeleniumContainers> seleniumContainersInstance;
    @Inject
    Instance<CubeRegistry> cubeRegistryInstance;

    public boolean canProvide(Class<?> type) {
        return URL.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        return this.resolveUrl();
    }

    private URL resolveUrl() {
        UrlBuilder urlBuilder = UrlBuilder.create();
        GrapheneConfiguration grapheneConfiguration = (GrapheneConfiguration)this.grapheneConfiguration.get();
        if (grapheneConfiguration.getScheme() != null) {
            urlBuilder.protocol(grapheneConfiguration.getScheme());
        }
        CubeDockerConfiguration cubeDockerConfiguration = (CubeDockerConfiguration)this.cubeDockerConfigurationInstance.get();
        String configuredUrl = grapheneConfiguration.getUrl();
        if (configuredUrl != null && !configuredUrl.isEmpty()) {
            if (this.isAnAbsoluteUrl(configuredUrl) || this.startWithDockerHost(configuredUrl)) {
                String replacedWithDockerHostUrl = configuredUrl;
                if (this.isAnAbsoluteUrl(configuredUrl)) {
                    replacedWithDockerHostUrl = configuredUrl.substring(1);
                }
                replacedWithDockerHostUrl = replacedWithDockerHostUrl.replace("dockerHost", cubeDockerConfiguration.getDockerServerIp());
                urlBuilder.host(this.resolveHost(replacedWithDockerHostUrl));
                urlBuilder.port(this.resolvePort(replacedWithDockerHostUrl));
                urlBuilder.context(this.resolveContext(replacedWithDockerHostUrl));
            } else {
                SinglePortBindResolver.PortBindInfo portBindInfo = this.resolveBindPort(-1);
                urlBuilder.host(this.getInternalIp(cubeDockerConfiguration, portBindInfo));
                urlBuilder.port(portBindInfo.getBindPort());
                urlBuilder.context(configuredUrl);
            }
        } else {
            SinglePortBindResolver.PortBindInfo portBindInfo = this.resolveBindPort(-1);
            urlBuilder.host(this.getInternalIp(cubeDockerConfiguration, portBindInfo));
            urlBuilder.port(portBindInfo.getBindPort());
        }
        try {
            return urlBuilder.build();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Configured custom URL from GrapheneConfiguration should be already a valid URL.");
        }
    }

    private String getInternalIp(CubeDockerConfiguration cubeDockerConfiguration, SinglePortBindResolver.PortBindInfo portBindInfo) {
        Cube cube = ((CubeRegistry)this.cubeRegistryInstance.get()).getCube(portBindInfo.getContainerName());
        if (cube == null) {
            return cubeDockerConfiguration.getDockerServerIp();
        }
        if (cube.hasMetadata(HasPortBindings.class)) {
            return ((HasPortBindings)cube.getMetadata(HasPortBindings.class)).getInternalIP();
        }
        return cubeDockerConfiguration.getDockerServerIp();
    }

    private String resolveContext(String url) {
        int indexOfSlash = url.indexOf(47);
        if (indexOfSlash > 0) {
            return url.substring(indexOfSlash + 1);
        }
        return "";
    }

    private int resolvePort(String url) {
        int port = this.extractPort(url);
        SinglePortBindResolver.PortBindInfo portBindInfo = this.resolveBindPort(port);
        if (portBindInfo == null) {
            return port;
        }
        return portBindInfo.getBindPort();
    }

    private SinglePortBindResolver.PortBindInfo resolveBindPort(int port) {
        CubeDockerConfiguration cubeDockerConfiguration = (CubeDockerConfiguration)this.cubeDockerConfigurationInstance.get();
        SeleniumContainers seleniumContainers = (SeleniumContainers)this.seleniumContainersInstance.get();
        if (port == -1) {
            return SinglePortBindResolver.resolvePortBindPort((CubeDockerConfiguration)cubeDockerConfiguration, (String[])new String[]{seleniumContainers.getSeleniumContainerName(), seleniumContainers.getVncContainerName()});
        }
        return SinglePortBindResolver.resolvePortBindPort((CubeDockerConfiguration)cubeDockerConfiguration, (int)port, (String[])new String[]{seleniumContainers.getSeleniumContainerName(), seleniumContainers.getVncContainerName()});
    }

    private int extractPort(String url) {
        int colonLocation = url.indexOf(58);
        if (colonLocation > 0) {
            for (int i = colonLocation + 1; i < url.length(); ++i) {
                if (url.charAt(i) != '/') continue;
                return Integer.parseInt(url.substring(colonLocation + 1, i));
            }
            return Integer.parseInt(url.substring(colonLocation + 1));
        }
        return -1;
    }

    private String resolveHost(String url) {
        for (int i = 0; i < url.length(); ++i) {
            if (url.charAt(i) != ':' && url.charAt(i) != '/') continue;
            return url.substring(0, i);
        }
        return url;
    }

    private boolean startWithDockerHost(String url) {
        return url.startsWith("dockerHost");
    }

    private boolean isAnAbsoluteUrl(String url) {
        return url.startsWith("/");
    }

    private static final class UrlBuilder {
        private String protocol = "http";
        private String host;
        private int port = -1;
        private String file = "";

        private UrlBuilder() {
        }

        public static UrlBuilder create() {
            return new UrlBuilder();
        }

        public UrlBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public UrlBuilder host(String host) {
            this.host = host;
            return this;
        }

        public UrlBuilder port(int port) {
            this.port = port;
            return this;
        }

        public UrlBuilder context(String context) {
            this.file = context;
            return this;
        }

        public URL build() throws MalformedURLException {
            if (this.protocol == null || this.protocol.isEmpty()) {
                throw new IllegalArgumentException("Protocol cannot be null or empty");
            }
            if (this.host == null || this.host.isEmpty()) {
                throw new IllegalArgumentException("Host cannot be null or empty");
            }
            if (this.port < 0) {
                throw new IllegalArgumentException("Port cannot be negative");
            }
            return new URL(this.protocol, this.host, this.port, this.file);
        }
    }
}

