/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.drone;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.arquillian.cube.docker.drone.CubeDroneConfiguration;
import org.arquillian.cube.docker.drone.SeleniumContainers;
import org.arquillian.cube.docker.drone.event.AfterVideoRecorded;
import org.arquillian.cube.docker.drone.util.VideoFileDestination;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;

public class VncRecorderLifecycleManager {
    @Inject
    Event<AfterVideoRecorded> afterVideoRecordedEvent;
    Cube vnc;

    public void startRecording(@Observes Before beforeTestMethod, CubeDroneConfiguration cubeDroneConfiguration, CubeRegistry cubeRegistry) {
        if (cubeDroneConfiguration.isRecording()) {
            this.initVncCube(cubeRegistry);
            this.vnc.create();
            this.vnc.start();
        }
    }

    private void initVncCube(CubeRegistry cubeRegistry) {
        if (this.vnc == null) {
            Cube vncContainer = cubeRegistry.getCube("vnc");
            if (vncContainer == null) {
                throw new IllegalArgumentException("VNC cube is not present in registry.");
            }
            this.vnc = vncContainer;
        }
    }

    public void stopRecording(@Observes After afterTestMethod, TestResult testResult, CubeDroneConfiguration cubeDroneConfiguration, SeleniumContainers seleniumContainers) {
        if (this.vnc != null) {
            Path finalLocation = null;
            if (this.shouldRecordOnlyOnFailure(testResult, cubeDroneConfiguration)) {
                finalLocation = this.moveFromVolumeFolderToBuildDirectory(afterTestMethod, cubeDroneConfiguration, seleniumContainers);
            } else if (this.shouldRecordAlways(cubeDroneConfiguration)) {
                finalLocation = this.moveFromVolumeFolderToBuildDirectory(afterTestMethod, cubeDroneConfiguration, seleniumContainers);
            }
            this.vnc.stop();
            this.vnc.destroy();
            this.afterVideoRecordedEvent.fire((Object)new AfterVideoRecorded(afterTestMethod, finalLocation));
        }
    }

    private boolean shouldRecordAlways(CubeDroneConfiguration cubeDroneConfiguration) {
        return cubeDroneConfiguration.isRecording() && !cubeDroneConfiguration.isRecordOnFailure();
    }

    private boolean shouldRecordOnlyOnFailure(TestResult testResult, CubeDroneConfiguration cubeDroneConfiguration) {
        return cubeDroneConfiguration.isRecordOnFailure() && testResult.getStatus() == TestResult.Status.FAILED;
    }

    private Path moveFromVolumeFolderToBuildDirectory(After afterTestMethod, CubeDroneConfiguration cubeDroneConfiguration, SeleniumContainers seleniumContainers) {
        try {
            Path finalLocation = this.getFinalLocation(cubeDroneConfiguration, afterTestMethod);
            Files.move(seleniumContainers.getVideoRecordingFile(), finalLocation, StandardCopyOption.REPLACE_EXISTING);
            return finalLocation;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Path getFinalLocation(CubeDroneConfiguration cubeDroneConfiguration, After afterTestMethod) {
        return VideoFileDestination.getFinalLocation(afterTestMethod, cubeDroneConfiguration);
    }
}

