/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.drone;

import java.util.Map;
import org.arquillian.cube.docker.drone.CubeDroneConfiguration;
import org.arquillian.cube.docker.drone.SeleniumContainers;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.util.ConfigUtil;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class InstallSeleniumCube {
    private static final String DEFAULT_BROWSER = "firefox";
    @Inject
    @ApplicationScoped
    InstanceProducer<SeleniumContainers> seleniumContainersInstanceProducer;
    @Inject
    Instance<CubeDroneConfiguration> cubeDroneConfigurationInstance;

    public void install(@Observes(precedence=90) CubeDockerConfiguration configuration, ArquillianDescriptor arquillianDescriptor) {
        DockerCompositions cubes = configuration.getDockerContainersContent();
        SeleniumContainers seleniumContainers = SeleniumContainers.create(this.getBrowser(arquillianDescriptor), (CubeDroneConfiguration)this.cubeDroneConfigurationInstance.get());
        cubes.add(seleniumContainers.getSeleniumContainerName(), seleniumContainers.getSeleniumContainer());
        boolean recording = ((CubeDroneConfiguration)this.cubeDroneConfigurationInstance.get()).isRecording();
        if (recording) {
            cubes.add(seleniumContainers.getVncContainerName(), seleniumContainers.getVncContainer());
            cubes.add(seleniumContainers.getVideoConverterContainerName(), seleniumContainers.getVideoConverterContainer());
        }
        this.seleniumContainersInstanceProducer.set((Object)seleniumContainers);
        System.out.println("SELENIUM INSTALLED");
        System.out.println(ConfigUtil.dump((DockerCompositions)cubes));
    }

    private String getBrowser(ArquillianDescriptor arquillianDescriptor) {
        ExtensionDef extension = arquillianDescriptor.extension("webdriver");
        if (extension == null) {
            return DEFAULT_BROWSER;
        }
        Map extensionProperties = extension.getExtensionProperties();
        if (extensionProperties == null) {
            return DEFAULT_BROWSER;
        }
        if (extensionProperties.containsKey("browser")) {
            return (String)extensionProperties.get("browser");
        }
        return DEFAULT_BROWSER;
    }
}

