/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.drone.util;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SeleniumVersionExtractor {
    private static final Logger logger = Logger.getLogger(SeleniumVersionExtractor.class.getName());
    private static final String SELENIUM_VERSION = "latest";

    public static String fromClassPath() {
        HashSet<String> versions = new HashSet<String>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> manifests = classLoader.getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL manifestURL = manifests.nextElement();
                InputStream is = manifestURL.openStream();
                Throwable throwable = null;
                try {
                    Attributes attributes;
                    Manifest manifest = new Manifest();
                    manifest.read(is);
                    Attributes buildInfo = manifest.getAttributes("Build-Info");
                    if (buildInfo == null) continue;
                    if (buildInfo.getValue("Selenium-Version") != null) {
                        versions.add(buildInfo.getValue("Selenium-Version"));
                        continue;
                    }
                    if (manifest.getEntries() == null || !manifest.getEntries().containsKey("Build-Info") || (attributes = manifest.getEntries().get("Build-Info")).getValue("Selenium-Version") == null) continue;
                    versions.add(attributes.getValue("Selenium-Version"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception {0} occurred while resolving selenium version and latest image is going to be used.", e.getMessage());
            return SELENIUM_VERSION;
        }
        if (versions.isEmpty()) {
            logger.log(Level.INFO, "No version of Selenium found in classpath. Using latest image.");
            return SELENIUM_VERSION;
        }
        String foundVersion = (String)versions.iterator().next();
        if (versions.size() > 1) {
            logger.log(Level.WARNING, "Multiple versions of Selenium found in classpath. Using the first one found {0}.", foundVersion);
        }
        return foundVersion;
    }
}

