/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.drone;

import java.util.Map;

public class CubeDroneConfiguration {
    private String finalDirectory;
    private RecordMode recordMode = RecordMode.ALL;
    private String browserImage = null;
    private String browserDockerfileLocation = null;
    private ContainerNameStrategy containerNameStrategy = ContainerNameStrategy.STATIC;
    private String containerNamePrefix = null;

    public static CubeDroneConfiguration fromMap(Map<String, String> config) {
        CubeDroneConfiguration cubeDroneConfiguration = new CubeDroneConfiguration();
        if (config.containsKey("recordingMode")) {
            cubeDroneConfiguration.recordMode = RecordMode.valueOf(config.get("recordingMode"));
        }
        if (config.containsKey("videoOutput")) {
            cubeDroneConfiguration.finalDirectory = config.get("videoOutput");
        }
        if (config.containsKey("browserImage")) {
            cubeDroneConfiguration.browserImage = config.get("browserImage");
        }
        if (config.containsKey("browserDockerfileLocation")) {
            cubeDroneConfiguration.browserDockerfileLocation = config.get("browserDockerfileLocation");
        }
        if (config.containsKey("containerNameStrategy")) {
            cubeDroneConfiguration.containerNameStrategy = ContainerNameStrategy.valueOf(config.get("containerNameStrategy"));
        }
        if (config.containsKey("containerNamePrefix")) {
            cubeDroneConfiguration.containerNamePrefix = config.get("containerNamePrefix");
        }
        return cubeDroneConfiguration;
    }

    public boolean isRecordOnFailure() {
        return this.recordMode == RecordMode.ONLY_FAILING;
    }

    public boolean isRecording() {
        return this.recordMode != RecordMode.NONE;
    }

    public RecordMode getRecordMode() {
        return this.recordMode;
    }

    public boolean isVideoOutputDirectorySet() {
        return this.finalDirectory != null;
    }

    public String getFinalDirectory() {
        return this.finalDirectory;
    }

    public boolean isBrowserImageSet() {
        return this.browserImage != null && !this.browserImage.isEmpty();
    }

    public boolean isBrowserDockerfileDirectorySet() {
        return this.browserDockerfileLocation != null && !this.browserDockerfileLocation.isEmpty();
    }

    public String getBrowserImage() {
        return this.browserImage;
    }

    public String getBrowserDockerfileLocation() {
        return this.browserDockerfileLocation;
    }

    public ContainerNameStrategy getContainerNameStrategy() {
        return this.containerNameStrategy;
    }

    public String getContainerNamePrefix() {
        return this.containerNamePrefix;
    }

    public static enum ContainerNameStrategy {
        STATIC,
        STATIC_PREFIX,
        RANDOM;

    }

    public static enum RecordMode {
        ALL,
        ONLY_FAILING,
        NONE;

    }
}

