/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.junit5;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.Network;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.junit.DockerClientInitializer;
import org.arquillian.cube.docker.junit.Reflections;
import org.arquillian.cube.docker.junit5.NetworkDsl;
import org.arquillian.cube.spi.metadata.IsNetworkContainerObject;
import org.arquillian.cube.spi.metadata.NetworkMetadata;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class NetworkDslResolver
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    private final DockerClientExecutor dockerClientExecutor;
    private final List<String> networkPerClass = new ArrayList<String>();
    private final List<String> networkPerMethod = new ArrayList<String>();

    public NetworkDslResolver() {
        this.dockerClientExecutor = DockerClientInitializer.initialize();
    }

    public void afterAll(ExtensionContext extensionContext) {
        for (String networkId : this.networkPerClass) {
            this.dockerClientExecutor.removeNetwork(networkId);
        }
    }

    public void afterEach(ExtensionContext extensionContext) {
        for (String networkId : this.networkPerMethod) {
            this.dockerClientExecutor.removeNetwork(networkId);
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        Class testClass = extensionContext.getRequiredTestClass();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        List allStaticNetworkDslFields = Reflections.findAllFieldsOfType((Class)testClass, NetworkDsl.class, f -> Modifier.isStatic(f.getModifiers()));
        this.networkPerClass.addAll(this.before(testInstance, allStaticNetworkDslFields));
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Class testClass = extensionContext.getRequiredTestClass();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        List allNetworkDslFields = Reflections.findAllFieldsOfType((Class)testClass, NetworkDsl.class, f -> !Modifier.isStatic(f.getModifiers()));
        this.networkPerMethod.addAll(this.before(testInstance, allNetworkDslFields));
    }

    private List<String> before(Object testInstance, List<Field> allStaticNetworkDslFields) throws IllegalAccessException {
        ArrayList<String> networks = new ArrayList<String>();
        for (Field networkDslField : allStaticNetworkDslFields) {
            NetworkDsl networkDsl = (NetworkDsl)networkDslField.get(testInstance);
            Network network = networkDsl.buildNetwork();
            org.arquillian.cube.docker.impl.client.config.Network dockerNetwork = network.getNetwork();
            String networkId = this.dockerClientExecutor.createNetwork(network.getId(), dockerNetwork);
            dockerNetwork.addMetadata(IsNetworkContainerObject.class, (NetworkMetadata)new IsNetworkContainerObject());
            networks.add(networkId);
        }
        return networks;
    }
}

