/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.junit5;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.arquillian.cube.docker.impl.client.SystemPropertiesCubeSetter;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.Container;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.docker.junit.DockerClientInitializer;
import org.arquillian.cube.docker.junit.Injector;
import org.arquillian.cube.docker.junit.Reflections;
import org.arquillian.cube.docker.junit5.ContainerDsl;
import org.arquillian.cube.impl.model.LocalCubeRegistry;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.lifecycle.AfterDestroy;
import org.arquillian.cube.spi.event.lifecycle.AfterStart;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ContainerDslResolver
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    private final DockerClientExecutor dockerClientExecutor;
    private final SystemPropertiesCubeSetter systemPropertiesCubeSetter = new SystemPropertiesCubeSetter();
    private final List<DockerCube> cubesPerMethod = new ArrayList<DockerCube>();
    private final List<DockerCube> cubesPerClass = new ArrayList<DockerCube>();

    public ContainerDslResolver() {
        this.dockerClientExecutor = DockerClientInitializer.initialize();
        this.systemPropertiesCubeSetter.createDockerHostProperty(new BeforeSuite(), this.dockerClientExecutor);
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.after(this.cubesPerClass);
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.after(this.cubesPerMethod);
    }

    private void after(List<DockerCube> dockerCubes) {
        for (DockerCube dockerCube : dockerCubes) {
            dockerCube.stop();
            dockerCube.destroy();
            this.systemPropertiesCubeSetter.removeCubeSystemProperties(new AfterDestroy(dockerCube.getId()));
            this.systemPropertiesCubeSetter.removeDockerHostProperty(new AfterSuite());
        }
        dockerCubes.clear();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        Class testClass = extensionContext.getRequiredTestClass();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        List allStaticContainerDslFields = Reflections.findAllFieldsOfType((Class)testClass, ContainerDsl.class, f -> Modifier.isStatic(f.getModifiers()));
        this.cubesPerClass.addAll(this.before(testInstance, allStaticContainerDslFields));
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Class testClass = extensionContext.getRequiredTestClass();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        List allContainerDslFields = Reflections.findAllFieldsOfType((Class)testClass, ContainerDsl.class, f -> !Modifier.isStatic(f.getModifiers()));
        this.cubesPerMethod.addAll(this.before(testInstance, allContainerDslFields));
    }

    private List<DockerCube> before(Object testInstance, List<Field> allStaticContainerDslFields) throws Exception {
        ArrayList<DockerCube> createdCubes = new ArrayList<DockerCube>();
        LocalCubeRegistry localCubeRegistry = new LocalCubeRegistry();
        for (Field containerDslField : allStaticContainerDslFields) {
            ContainerDsl containerDsl = (ContainerDsl)containerDslField.get(testInstance);
            Container container = containerDsl.buildContainer();
            DockerCube dockerCube = Injector.prepareContainer((Container)container, (DockerClientExecutor)this.dockerClientExecutor, (LocalCubeRegistry)localCubeRegistry);
            createdCubes.add(dockerCube);
            dockerCube.create();
            dockerCube.start();
            this.systemPropertiesCubeSetter.createCubeSystemProperties(new AfterStart(dockerCube.getId()), (CubeRegistry)localCubeRegistry);
        }
        return createdCubes;
    }
}

