/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.reporter;

import com.github.dockerjava.api.model.Statistics;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.reporter.CubeStatistics;
import org.arquillian.cube.docker.impl.client.utils.NumberConversion;

public class ContainerStatsBuilder {
    public static CubeStatistics updateStats(Statistics statistics) {
        CubeStatistics stats = new CubeStatistics();
        Map<String, Long> blkio = ContainerStatsBuilder.extractIORW(statistics.getBlkioStats());
        Map<String, Long> memory = ContainerStatsBuilder.extractMemoryStats(statistics.getMemoryStats(), "usage", "max_usage", "limit");
        stats.setIoBytesRead(blkio.get("io_bytes_read"));
        stats.setIoBytesWrite(blkio.get("io_bytes_write"));
        stats.setMaxUsage(memory.get("max_usage"));
        stats.setUsage(memory.get("usage"));
        stats.setLimit(memory.get("limit"));
        stats.setNetworks(ContainerStatsBuilder.extractNetworksStats(statistics.getNetworks()));
        return stats;
    }

    private static Map<String, Map<String, Long>> extractNetworksStats(Map<String, Object> map) {
        LinkedHashMap<String, Map<String, Long>> nwStatsForEachNICAndTotal = new LinkedHashMap<String, Map<String, Long>>();
        if (map != null) {
            long totalRxBytes = 0L;
            long totalTxBytes = 0L;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                LinkedHashMap<String, Long> nwStats = new LinkedHashMap<String, Long>();
                String adapterName = entry.getKey();
                if (!(entry.getValue() instanceof LinkedHashMap)) continue;
                LinkedHashMap adapter = (LinkedHashMap)entry.getValue();
                long rxBytes = NumberConversion.convertToLong(adapter.get("rx_bytes"));
                long txBytes = NumberConversion.convertToLong(adapter.get("tx_bytes"));
                nwStats.put("rx_bytes", rxBytes);
                nwStats.put("tx_bytes", txBytes);
                nwStatsForEachNICAndTotal.put(adapterName, nwStats);
                totalRxBytes += rxBytes;
                totalTxBytes += txBytes;
            }
            LinkedHashMap<String, Long> total = new LinkedHashMap<String, Long>();
            total.put("rx_bytes", totalRxBytes);
            total.put("tx_bytes", totalTxBytes);
            nwStatsForEachNICAndTotal.put("Total", total);
        }
        return nwStatsForEachNICAndTotal;
    }

    private static Map<String, Long> extractIORW(Map<String, Object> blkioStats) {
        LinkedHashMap<String, Long> blkrwStats = new LinkedHashMap<String, Long>();
        if (blkioStats != null && !blkioStats.isEmpty()) {
            ArrayList bios = (ArrayList)blkioStats.get("io_service_bytes_recursive");
            long read = 0L;
            long write = 0L;
            if (bios != null) {
                for (Map io : bios) {
                    if (io == null) continue;
                    switch ((String)io.get("op")) {
                        case "Read": {
                            read = NumberConversion.convertToLong(io.get("value"));
                            break;
                        }
                        case "Write": {
                            write = NumberConversion.convertToLong(io.get("value"));
                        }
                    }
                }
            }
            blkrwStats.put("io_bytes_read", read);
            blkrwStats.put("io_bytes_write", write);
        }
        return blkrwStats;
    }

    private static Map<String, Long> extractMemoryStats(Map<String, Object> map, String ... fields) {
        LinkedHashMap<String, Long> memory = new LinkedHashMap<String, Long>();
        if (map != null) {
            for (String field : fields) {
                long usage = NumberConversion.convertToLong(map.get(field));
                memory.put(field, usage);
            }
        }
        return memory;
    }
}

