/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.restassured;

import io.restassured.RestAssured;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.util.SinglePortBindResolver;
import org.arquillian.cube.docker.restassured.RestAssuredConfiguration;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStopping;

public class RestAssuredCustomizer {
    @Inject
    Instance<CubeDockerConfiguration> cubeDockerConfigurationInstance;

    public void configure(@Observes RestAssuredConfiguration restAssuredConfiguration) {
        CubeDockerConfiguration cubeDockerConfiguration = (CubeDockerConfiguration)this.cubeDockerConfigurationInstance.get();
        RestAssured.baseURI = restAssuredConfiguration.isBaseUriSet() ? restAssuredConfiguration.getBaseUri() : restAssuredConfiguration.getSchema() + "://" + cubeDockerConfiguration.getDockerServerIp();
        RestAssured.port = restAssuredConfiguration.isPortSet() ? SinglePortBindResolver.resolveBindPort((CubeDockerConfiguration)cubeDockerConfiguration, (int)restAssuredConfiguration.getPort(), (String[])restAssuredConfiguration.getExclusionContainers()) : SinglePortBindResolver.resolveBindPort((CubeDockerConfiguration)cubeDockerConfiguration, (String[])restAssuredConfiguration.getExclusionContainers());
        if (restAssuredConfiguration.isBasePathSet()) {
            RestAssured.basePath = restAssuredConfiguration.getBasePath();
        }
        if (restAssuredConfiguration.isAuthenticationSchemeSet()) {
            RestAssured.authentication = restAssuredConfiguration.getAuthenticationScheme();
        }
        if (restAssuredConfiguration.isRootPath()) {
            RestAssured.rootPath = restAssuredConfiguration.getRootPath();
        }
        if (restAssuredConfiguration.isUseRelaxedHttpsValidationSet()) {
            if (restAssuredConfiguration.isUseRelaxedHttpsValidationInAllProtocols()) {
                RestAssured.useRelaxedHTTPSValidation();
            } else {
                RestAssured.useRelaxedHTTPSValidation((String)restAssuredConfiguration.getUseRelaxedHttpsValidation());
            }
        }
    }

    public void resetRestAssuredConfiguration(@Observes ManagerStopping event) {
        RestAssured.reset();
    }
}

