/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.restassured;

import io.restassured.authentication.AuthenticationScheme;
import java.util.Map;
import org.arquillian.cube.docker.restassured.AuthenticationSchemeFactory;

public class RestAssuredConfiguration {
    private static final String RELAXED_HTTPS_VALIDATION_ALL_PROTOCOLS = "";
    private String baseUri;
    private String schema = "http";
    private int port = -1;
    private String basePath;
    private String rootPath;
    private AuthenticationScheme authenticationScheme;
    private String useRelaxedHttpsValidation;
    private String[] exclusionContainers = new String[0];

    public static RestAssuredConfiguration fromMap(Map<String, String> conf) {
        RestAssuredConfiguration restAssuredConfiguration = new RestAssuredConfiguration();
        if (conf.containsKey("baseUri")) {
            restAssuredConfiguration.baseUri = conf.get("baseUri");
        }
        if (conf.containsKey("port")) {
            restAssuredConfiguration.port = Integer.parseInt(conf.get("port"));
        }
        if (conf.containsKey("basePath")) {
            restAssuredConfiguration.basePath = conf.get("basePath");
        }
        if (conf.containsKey("rootPath")) {
            restAssuredConfiguration.rootPath = conf.get("rootPath");
        }
        if (conf.containsKey("authenticationScheme")) {
            restAssuredConfiguration.authenticationScheme = AuthenticationSchemeFactory.create(conf.get("authenticationScheme"));
        }
        if (conf.containsKey("schema")) {
            restAssuredConfiguration.schema = conf.get("schema");
        }
        if (conf.containsKey("exclusionContainers")) {
            restAssuredConfiguration.exclusionContainers = conf.get("exclusionContainers").split(",");
            for (int i = 0; i < restAssuredConfiguration.exclusionContainers.length; ++i) {
                restAssuredConfiguration.exclusionContainers[i] = restAssuredConfiguration.exclusionContainers[i].trim();
            }
        }
        if (conf.containsKey("useRelaxedHttpsValidation")) {
            String useRelaxedHttpsValidation = conf.get("useRelaxedHttpsValidation");
            restAssuredConfiguration.useRelaxedHttpsValidation = useRelaxedHttpsValidation == null || useRelaxedHttpsValidation.isEmpty() ? RELAXED_HTTPS_VALIDATION_ALL_PROTOCOLS : useRelaxedHttpsValidation;
        }
        return restAssuredConfiguration;
    }

    public String getUseRelaxedHttpsValidation() {
        return this.useRelaxedHttpsValidation;
    }

    public boolean isUseRelaxedHttpsValidationSet() {
        return this.useRelaxedHttpsValidation != null;
    }

    public boolean isUseRelaxedHttpsValidationInAllProtocols() {
        return RELAXED_HTTPS_VALIDATION_ALL_PROTOCOLS.equals(this.useRelaxedHttpsValidation);
    }

    public boolean isAuthenticationSchemeSet() {
        return this.authenticationScheme != null;
    }

    public AuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public boolean isPortSet() {
        return this.port > -1;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isBasePathSet() {
        return this.basePath != null && !this.basePath.isEmpty();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean isBaseUriSet() {
        return this.baseUri != null && !this.baseUri.isEmpty();
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String[] getExclusionContainers() {
        return this.exclusionContainers;
    }

    public String getSchema() {
        return this.schema;
    }
}

