/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.util;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.Binding;

public final class BindingUtil {
    private static final String NO_GATEWAY = null;

    private BindingUtil() {
    }

    public static Binding binding(DockerClientExecutor executor, String cubeId) {
        InspectContainerResponse inspectResponse = executor.getDockerClient().inspectContainerCmd(cubeId).exec();
        InspectContainerResponse.HostConfig hostConfig = inspectResponse.getHostConfig();
        String gatewayIp = inspectResponse.getNetworkSettings().getGateway();
        Binding binding = new Binding(gatewayIp);
        for (Map.Entry bind : hostConfig.getPortBindings().getBindings().entrySet()) {
            binding.addPortBinding(Integer.valueOf(((ExposedPort)bind.getKey()).getPort()), Integer.valueOf(((Ports.Binding)bind.getValue()).getHostPort()));
        }
        return binding;
    }

    public static Binding binding(Map<String, Object> cubeConfiguration) {
        Binding binding = new Binding(NO_GATEWAY);
        if (cubeConfiguration.containsKey("portBindings")) {
            List cubePortBindings = (List)cubeConfiguration.get("portBindings");
            for (Map cubePortBinding : cubePortBindings) {
                if (!cubePortBinding.containsKey("exposedPort") || !cubePortBinding.containsKey("port")) continue;
                String exposedPortAndProtocol = (String)cubePortBinding.get("exposedPort");
                int exposedPort = Integer.parseInt(exposedPortAndProtocol.substring(0, exposedPortAndProtocol.indexOf("/")));
                int port = (Integer)cubePortBinding.get("port");
                binding.addPortBinding(Integer.valueOf(exposedPort), Integer.valueOf(port));
            }
        }
        return binding;
    }
}

