/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.await.AwaitStrategy;

public class CustomAwaitStrategyInstantiator
implements AwaitStrategy {
    private Cube<?> cube;
    private DockerClientExecutor dockerClientExecutor;
    private Await params;

    public CustomAwaitStrategyInstantiator(Cube<?> cube, DockerClientExecutor dockerClientExecutor, Await params) {
        this.cube = cube;
        this.dockerClientExecutor = dockerClientExecutor;
        this.params = params;
    }

    public boolean await() {
        String className = this.params.getStrategy();
        try {
            Class<?> customStrategy = Class.forName(className);
            AwaitStrategy customStrategyInstance = (AwaitStrategy)customStrategy.newInstance();
            Field[] fields = customStrategyInstance.getClass().getDeclaredFields();
            for (Field field : fields) {
                if (field.getType().isAssignableFrom(Cube.class)) {
                    field.setAccessible(true);
                    field.set(customStrategyInstance, this.cube);
                    continue;
                }
                if (field.getType().isAssignableFrom(DockerClientExecutor.class)) {
                    field.setAccessible(true);
                    field.set(customStrategyInstance, this.dockerClientExecutor);
                    continue;
                }
                if (!field.getType().isAssignableFrom(Await.class)) continue;
                field.setAccessible(true);
                field.set(customStrategyInstance, this.params);
            }
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(customStrategyInstance.getClass()).getPropertyDescriptors()) {
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (writeMethod == null) continue;
                if (writeMethod.getParameterTypes()[0].isAssignableFrom(Cube.class)) {
                    writeMethod.invoke((Object)customStrategyInstance, this.cube);
                    continue;
                }
                if (writeMethod.getParameterTypes()[0].isAssignableFrom(DockerClientExecutor.class)) {
                    writeMethod.invoke((Object)customStrategyInstance, this.dockerClientExecutor);
                    continue;
                }
                if (!writeMethod.getParameterTypes()[0].isAssignableFrom(Await.class)) continue;
                writeMethod.invoke((Object)customStrategyInstance, this.params);
            }
            return customStrategyInstance.await();
        }
        catch (IntrospectionException | ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

