/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import com.github.dockerjava.api.model.Container;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.DockerAutoStartOrder;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.ConnectionMode;
import org.arquillian.cube.spi.CubeConfiguration;
import org.arquillian.cube.spi.event.CreateCube;
import org.arquillian.cube.spi.event.CubeControlEvent;
import org.arquillian.cube.spi.event.DestroyCube;
import org.arquillian.cube.spi.event.PreRunningCube;
import org.arquillian.cube.spi.event.StartCube;
import org.arquillian.cube.spi.event.StopCube;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.threading.ExecutorService;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class CubeSuiteLifecycleController {
    @Inject
    private Event<CubeControlEvent> controlEvent;
    @Inject
    private Instance<ExecutorService> executorServiceInst;
    @Inject
    private Instance<DockerClientExecutor> dockerClientExecutor;

    public void startAutoContainers(@Observes(precedence=100) BeforeSuite event, CubeConfiguration cubeConfiguration, CubeDockerConfiguration dockerConfiguration) {
        DockerAutoStartOrder dockerAutoStartOrder = dockerConfiguration.getDockerAutoStartOrder();
        List autoStartSteps = dockerAutoStartOrder.getAutoStartOrder(dockerConfiguration);
        this.startAllSteps(autoStartSteps, cubeConfiguration.getConnectionMode());
    }

    public void stopAutoContainers(@Observes(precedence=-100) AfterSuite event, CubeDockerConfiguration configuration) {
        DockerAutoStartOrder dockerAutoStartOrder = configuration.getDockerAutoStartOrder();
        List autoStopSteps = dockerAutoStartOrder.getAutoStopOrder(configuration);
        this.stopAllSteps(autoStopSteps);
    }

    private void startAllSteps(List<String[]> autoStartSteps, ConnectionMode connectionMode) {
        for (String[] cubeIds : autoStartSteps) {
            HashMap<String, Future<RuntimeException>> stepStatus = new HashMap<String, Future<RuntimeException>>();
            for (String cubeId : cubeIds) {
                Future result = ((ExecutorService)this.executorServiceInst.get()).submit((Callable)new StartCubes(cubeId, connectionMode));
                stepStatus.put(cubeId, result);
            }
            this.waitForCompletion(stepStatus, "Could not auto start container");
        }
    }

    private void stopAllSteps(List<String[]> autoStopSteps) {
        for (String[] cubeIds : autoStopSteps) {
            HashMap<String, Future<RuntimeException>> stepStatus = new HashMap<String, Future<RuntimeException>>();
            for (String cubeId : cubeIds) {
                Future result = ((ExecutorService)this.executorServiceInst.get()).submit((Callable)new StopCubes(cubeId));
                stepStatus.put(cubeId, result);
            }
            this.waitForCompletion(stepStatus, "Could not auto stop container");
        }
    }

    private void waitForCompletion(Map<String, Future<RuntimeException>> stepStatus, String message) {
        for (Map.Entry<String, Future<RuntimeException>> result : stepStatus.entrySet()) {
            try {
                RuntimeException e = result.getValue().get();
                if (e == null) continue;
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(message + " " + result.getKey(), e);
            }
        }
    }

    private boolean isCubeRunning(String cube) {
        List<Container> runningContainers = ((DockerClientExecutor)this.dockerClientExecutor.get()).listRunningContainers();
        for (Container container : runningContainers) {
            for (String name : container.getNames()) {
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                if (!name.equals(cube)) continue;
                return true;
            }
        }
        return false;
    }

    private final class StopCubes
    implements Callable<RuntimeException> {
        private final String cubeId;

        private StopCubes(String cubeId) {
            this.cubeId = cubeId;
        }

        @Override
        public RuntimeException call() throws Exception {
            try {
                CubeSuiteLifecycleController.this.controlEvent.fire((Object)new StopCube(this.cubeId));
                CubeSuiteLifecycleController.this.controlEvent.fire((Object)new DestroyCube(this.cubeId));
            }
            catch (RuntimeException e) {
                return e;
            }
            return null;
        }
    }

    private final class StartCubes
    implements Callable<RuntimeException> {
        private final ConnectionMode connectionMode;
        private final String cubeId;

        private StartCubes(String cubeId, ConnectionMode connectionMode) {
            this.cubeId = cubeId;
            this.connectionMode = connectionMode;
        }

        @Override
        public RuntimeException call() throws Exception {
            try {
                if (this.connectionMode.isAllowReconnect() && CubeSuiteLifecycleController.this.isCubeRunning(this.cubeId)) {
                    CubeSuiteLifecycleController.this.controlEvent.fire((Object)new PreRunningCube(this.cubeId));
                    return null;
                }
                CubeSuiteLifecycleController.this.controlEvent.fire((Object)new CreateCube(this.cubeId));
                CubeSuiteLifecycleController.this.controlEvent.fire((Object)new StartCube(this.cubeId));
                if (this.connectionMode.isAllowReconnect() && !this.connectionMode.isStoppable()) {
                    CubeSuiteLifecycleController.this.controlEvent.fire((Object)new PreRunningCube(this.cubeId));
                }
            }
            catch (RuntimeException e) {
                return e;
            }
            return null;
        }
    }
}

