/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.model;

import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.Container;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.arquillian.cube.docker.impl.await.AwaitStrategyFactory;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.metadata.ChangesOnFilesystem;
import org.arquillian.cube.docker.impl.client.metadata.CopyFromContainer;
import org.arquillian.cube.docker.impl.client.metadata.CopyToContainer;
import org.arquillian.cube.docker.impl.client.metadata.ExecuteProcessInContainer;
import org.arquillian.cube.docker.impl.client.metadata.GetTop;
import org.arquillian.cube.docker.impl.client.metadata.ReportMetrics;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.util.BindingUtil;
import org.arquillian.cube.spi.BaseCube;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeControlException;
import org.arquillian.cube.spi.event.lifecycle.AfterCreate;
import org.arquillian.cube.spi.event.lifecycle.AfterDestroy;
import org.arquillian.cube.spi.event.lifecycle.AfterStart;
import org.arquillian.cube.spi.event.lifecycle.AfterStop;
import org.arquillian.cube.spi.event.lifecycle.BeforeCreate;
import org.arquillian.cube.spi.event.lifecycle.BeforeDestroy;
import org.arquillian.cube.spi.event.lifecycle.BeforeStart;
import org.arquillian.cube.spi.event.lifecycle.BeforeStop;
import org.arquillian.cube.spi.event.lifecycle.CubeLifecyleEvent;
import org.arquillian.cube.spi.metadata.CanCopyFromContainer;
import org.arquillian.cube.spi.metadata.CanCopyToContainer;
import org.arquillian.cube.spi.metadata.CanExecuteProcessInContainer;
import org.arquillian.cube.spi.metadata.CanReportMetrics;
import org.arquillian.cube.spi.metadata.CanSeeChangesOnFilesystem;
import org.arquillian.cube.spi.metadata.CanSeeTop;
import org.arquillian.cube.spi.metadata.CubeMetadata;
import org.arquillian.cube.spi.metadata.HasPortBindings;
import org.arquillian.cube.spi.metadata.IsBuildable;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;

public class DockerCube
extends BaseCube<CubeContainer> {
    private static final Logger log = Logger.getLogger(DockerCube.class.getName());
    private Cube.State state = Cube.State.DESTROYED;
    private String id;
    private Binding binding = null;
    private CubeContainer configuration;
    private final PortBindings portBindings;
    private long startingTimeInMillis = 0L;
    private long stoppingTimeInMillis = 0L;
    @Inject
    private Event<CubeLifecyleEvent> lifecycle;
    private DockerClientExecutor executor;

    public DockerCube(String id, CubeContainer configuration, DockerClientExecutor executor) {
        this.id = id;
        this.configuration = configuration;
        this.executor = executor;
        this.portBindings = new PortBindings();
        this.addDefaultMetadata();
    }

    private void addDefaultMetadata() {
        String path;
        this.addMetadata(CanCopyToContainer.class, (CubeMetadata)new CopyToContainer(this.getId(), this.executor));
        this.addMetadata(CanExecuteProcessInContainer.class, (CubeMetadata)new ExecuteProcessInContainer(this.getId(), this.executor));
        this.addMetadata(CanCopyFromContainer.class, (CubeMetadata)new CopyFromContainer(this.getId(), this.executor));
        this.addMetadata(CanSeeChangesOnFilesystem.class, (CubeMetadata)new ChangesOnFilesystem(this.getId(), this.executor));
        this.addMetadata(CanSeeTop.class, (CubeMetadata)new GetTop(this.getId(), this.executor));
        this.addMetadata(HasPortBindings.class, (CubeMetadata)this.portBindings);
        this.addMetadata(CanReportMetrics.class, (CubeMetadata)new ReportMetrics(this));
        if (this.configuration.getBuildImage() != null && (path = this.configuration.getBuildImage().getDockerfileLocation()) != null) {
            this.addMetadata(IsBuildable.class, (CubeMetadata)new IsBuildable(path));
        }
    }

    public Cube.State state() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public void create() throws CubeControlException {
        if (this.state != Cube.State.DESTROYED) {
            return;
        }
        try {
            this.lifecycle.fire((Object)new BeforeCreate(this.id));
            log.fine(String.format("Creating container with name %s and configuration %s.", this.id, this.configuration));
            long currentTime = System.currentTimeMillis();
            this.executor.createContainer(this.id, this.configuration);
            this.startingTimeInMillis = System.currentTimeMillis() - currentTime;
            log.fine(String.format("Created container with id %s.", this.id));
            this.state = Cube.State.CREATED;
            this.lifecycle.fire((Object)new AfterCreate(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.CREATE_FAILED;
            throw CubeControlException.failedCreate((String)this.id, (Throwable)e);
        }
    }

    public void start() throws CubeControlException {
        if (this.state == Cube.State.STARTED || this.state == Cube.State.PRE_RUNNING) {
            return;
        }
        try {
            this.lifecycle.fire((Object)new BeforeStart(this.id));
            long currentTime = System.currentTimeMillis();
            this.executor.startContainer(this.id, this.configuration);
            long partialDuration = System.currentTimeMillis() - currentTime;
            this.startingTimeInMillis += partialDuration;
            this.state = Cube.State.STARTED;
            this.portBindings.containerStarted();
            if (!AwaitStrategyFactory.create(this.executor, this, this.configuration).await()) {
                throw new IllegalArgumentException(String.format("Cannot connect to %s container", this.id));
            }
            this.lifecycle.fire((Object)new AfterStart(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.START_FAILED;
            throw CubeControlException.failedStart((String)this.id, (Throwable)e);
        }
    }

    public void stop() throws CubeControlException {
        if (this.state == Cube.State.STOPPED || this.state == Cube.State.PRE_RUNNING) {
            return;
        }
        try {
            this.lifecycle.fire((Object)new BeforeStop(this.id));
            long currentTime = System.currentTimeMillis();
            try {
                this.executor.stopContainer(this.id);
            }
            catch (NotFoundException notFoundException) {
            }
            catch (NotModifiedException notModifiedException) {
                // empty catch block
            }
            this.stoppingTimeInMillis = System.currentTimeMillis() - currentTime;
            this.state = Cube.State.STOPPED;
            this.lifecycle.fire((Object)new AfterStop(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.STOP_FAILED;
            throw CubeControlException.failedStop((String)this.id, (Throwable)e);
        }
    }

    public void destroy() throws CubeControlException {
        if (this.state != Cube.State.STOPPED) {
            return;
        }
        try {
            this.lifecycle.fire((Object)new BeforeDestroy(this.id));
            long currentTime = System.currentTimeMillis();
            try {
                this.executor.removeContainer(this.id, this.configuration.getRemoveVolumes());
            }
            catch (NotFoundException notFoundException) {
            }
            catch (NotModifiedException notModifiedException) {
                // empty catch block
            }
            long partialDuration = System.currentTimeMillis() - currentTime;
            this.stoppingTimeInMillis += partialDuration;
            this.state = Cube.State.DESTROYED;
            this.lifecycle.fire((Object)new AfterDestroy(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.DESTORY_FAILED;
            throw CubeControlException.failedDestroy((String)this.id, (Throwable)e);
        }
    }

    public Binding bindings() {
        if (this.binding != null) {
            return this.binding;
        }
        if (this.state != Cube.State.STARTED && this.state != Cube.State.PRE_RUNNING) {
            throw new IllegalStateException("Can't get binding for cube " + this.id + " when status not " + Cube.State.STARTED + " or " + Cube.State.PRE_RUNNING + ". Status is " + this.state);
        }
        this.binding = BindingUtil.binding(this.executor, this.id);
        return this.binding;
    }

    public Binding configuredBindings() {
        return BindingUtil.binding(this.configuration, this.executor);
    }

    public boolean isRunningOnRemote() {
        List<Container> runningContainers = this.executor.listRunningContainers();
        for (Container container : runningContainers) {
            for (String name : container.getNames()) {
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                if (!name.equals(this.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public CubeContainer configuration() {
        return this.configuration;
    }

    public void changeToPreRunning() {
        if (this.state != Cube.State.DESTROYED && this.state != Cube.State.STARTED) {
            return;
        }
        log.fine(String.format("Reusing prerunning container with name %s and configuration %s.", this.id, this.configuration));
        this.state = Cube.State.PRE_RUNNING;
    }

    public long getStartingTimeInMillis() {
        return this.startingTimeInMillis;
    }

    public long getStoppingTimeInMillis() {
        return this.stoppingTimeInMillis;
    }

    private class PortBindings
    implements HasPortBindings {
        private final Map<Integer, HasPortBindings.PortAddress> mappedPorts = new HashMap<Integer, HasPortBindings.PortAddress>();
        private final Set<Integer> containerPorts = new LinkedHashSet<Integer>();
        private final Set<Integer> boundPorts;
        private String containerIP;
        private String internalIP;

        private PortBindings() {
            Binding configuredBindings = DockerCube.this.configuredBindings();
            this.containerIP = configuredBindings.getIP();
            for (Binding.PortBinding portBinding : configuredBindings.getPortBindings()) {
                int exposedPort = portBinding.getExposedPort();
                Integer boundPort = portBinding.getBindingPort();
                this.containerPorts.add(exposedPort);
                if (boundPort == null || this.containerIP == null) continue;
                this.mappedPorts.put(exposedPort, (HasPortBindings.PortAddress)new HasPortBindings.PortAddressImpl(this.containerIP, boundPort.intValue()));
            }
            this.boundPorts = new LinkedHashSet<Integer>(this.containerPorts.size());
        }

        public boolean isBound() {
            return EnumSet.of(Cube.State.PRE_RUNNING, Cube.State.STARTED).contains(DockerCube.this.state);
        }

        public synchronized String getContainerIP() {
            return this.containerIP;
        }

        public String getInternalIP() {
            return this.internalIP;
        }

        public Set<Integer> getContainerPorts() {
            return Collections.unmodifiableSet(this.containerPorts);
        }

        public synchronized Set<Integer> getBoundPorts() {
            return this.isBound() ? Collections.unmodifiableSet(this.boundPorts) : this.getContainerPorts();
        }

        public synchronized HasPortBindings.PortAddress getMappedAddress(int targetPort) {
            if (this.mappedPorts.containsKey(targetPort)) {
                return this.mappedPorts.get(targetPort);
            }
            return null;
        }

        private synchronized void containerStarted() {
            Binding bindings = DockerCube.this.bindings();
            this.containerIP = bindings.getIP();
            this.internalIP = bindings.getInternalIP();
            for (Binding.PortBinding portBinding : bindings.getPortBindings()) {
                int exposedPort = portBinding.getExposedPort();
                Integer boundPort = portBinding.getBindingPort();
                this.boundPorts.add(exposedPort);
                if (boundPort == null || this.containerIP == null) continue;
                this.mappedPorts.put(exposedPort, (HasPortBindings.PortAddress)new HasPortBindings.PortAddressImpl(this.containerIP, boundPort.intValue()));
            }
        }
    }
}

