/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.client.config.PortBinding;

public class SinglePortBindResolver {
    private static final int NO_PORT = -1;

    private SinglePortBindResolver() {
    }

    public static int resolveBindPort(CubeDockerConfiguration cubeDockerConfiguration, int exposedPort, String ... excludedContainers) {
        PortBindInfo portBinding = SinglePortBindResolver.resolvePortBindPort(cubeDockerConfiguration, exposedPort, excludedContainers);
        if (portBinding == null) {
            return exposedPort;
        }
        return portBinding.getBindPort();
    }

    public static PortBindInfo resolvePortBindPort(CubeDockerConfiguration cubeDockerConfiguration, int exposedPort, String ... excludedContainers) {
        DockerCompositions dockerContainersContent = cubeDockerConfiguration.getDockerContainersContent();
        Set<Map.Entry<String, CubeContainer>> containers = dockerContainersContent.getContainers().entrySet();
        PortBindInfo portBindInfo = null;
        for (Map.Entry<String, CubeContainer> cubeContainerEntry : containers) {
            if (SinglePortBindResolver.shouldBeIgnored(cubeContainerEntry.getKey(), excludedContainers)) continue;
            CubeContainer cubeContainer = cubeContainerEntry.getValue();
            Collection<PortBinding> portBindings = cubeContainer.getPortBindings();
            if (portBindings != null) {
                for (PortBinding portBinding : portBindings) {
                    if (portBinding.getExposedPort().getExposed() != exposedPort) continue;
                    if (SinglePortBindResolver.noPreviousBindPortFound(portBindInfo)) {
                        int bindPort = portBinding.getBound();
                        portBindInfo = new PortBindInfo(bindPort, cubeContainerEntry.getKey());
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("More than one docker container with port binding having exposed port %s.", exposedPort));
                }
            }
            if (!SinglePortBindResolver.noPreviousBindPortFound(portBindInfo)) continue;
            return null;
        }
        return portBindInfo;
    }

    public static int resolveBindPort(CubeDockerConfiguration cubeDockerConfiguration, String ... excludedContainers) {
        PortBindInfo portBinding = SinglePortBindResolver.resolvePortBindPort(cubeDockerConfiguration, excludedContainers);
        if (portBinding == null) {
            throw new IllegalArgumentException("There isn't any bind port.");
        }
        return portBinding.getBindPort();
    }

    public static PortBindInfo resolvePortBindPort(CubeDockerConfiguration cubeDockerConfiguration, String ... excludedContainers) {
        DockerCompositions dockerContainersContent = cubeDockerConfiguration.getDockerContainersContent();
        Set<Map.Entry<String, CubeContainer>> containers = dockerContainersContent.getContainers().entrySet();
        PortBindInfo portBindInfo = null;
        for (Map.Entry<String, CubeContainer> cubeContainerEntry : containers) {
            if (SinglePortBindResolver.shouldBeIgnored(cubeContainerEntry.getKey(), excludedContainers)) continue;
            CubeContainer cubeContainer = cubeContainerEntry.getValue();
            if (SinglePortBindResolver.hasMoreThanOneBindPort(cubeContainer)) {
                throw new IllegalArgumentException("No port was specified and a container has more than one bind port.");
            }
            if (!SinglePortBindResolver.hasOnlyOneBindPort(cubeContainer)) continue;
            if (SinglePortBindResolver.noPreviousBindPortFound(portBindInfo)) {
                int bindPort = cubeContainer.getPortBindings().iterator().next().getBound();
                portBindInfo = new PortBindInfo(bindPort, cubeContainerEntry.getKey());
                continue;
            }
            throw new IllegalArgumentException("No port was specified and in all containers there are more than one bind port.");
        }
        if (SinglePortBindResolver.noPreviousBindPortFound(portBindInfo)) {
            throw new IllegalArgumentException("There isn't any bind port.");
        }
        return portBindInfo;
    }

    private static boolean shouldBeIgnored(String containerId, String ... excludedContainers) {
        for (String excludedContainer : excludedContainers) {
            if (!excludedContainer.equals(containerId)) continue;
            return true;
        }
        return false;
    }

    private static boolean noPreviousBindPortFound(PortBindInfo bindPort) {
        return bindPort == null;
    }

    private static boolean hasOnlyOneBindPort(CubeContainer cubeContainer) {
        Collection<PortBinding> portBindings = cubeContainer.getPortBindings();
        if (portBindings == null) {
            return false;
        }
        return portBindings.size() == 1;
    }

    private static boolean hasMoreThanOneBindPort(CubeContainer cubeContainer) {
        Collection<PortBinding> portBindings = cubeContainer.getPortBindings();
        if (portBindings == null) {
            return false;
        }
        return portBindings.size() > 1;
    }

    public static class PortBindInfo {
        private int bindPort;
        private String containerName;

        public PortBindInfo(int bindPort, String containerName) {
            this.bindPort = bindPort;
            this.containerName = containerName;
        }

        public int getBindPort() {
            return this.bindPort;
        }

        public String getContainerName() {
            return this.containerName;
        }
    }
}

