/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;

public class ContainerObjectUtil {
    private ContainerObjectUtil() {
    }

    public static <T> T getTopCubeAttribute(final Class<?> source, final String nameField, final Class<? extends Annotation> annotationClass, final T defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                Method field = null;
                try {
                    field = annotationClass.getMethod(nameField, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(e);
                }
                Class nextSource = source;
                boolean foundAnnotation = false;
                while (nextSource != Object.class) {
                    if (nextSource.isAnnotationPresent(annotationClass)) {
                        foundAnnotation = true;
                        Object annotation = nextSource.getAnnotation(annotationClass);
                        Object value = ContainerObjectUtil.getValue(annotation, field);
                        if (defaultValue.getClass().isArray() ? !Arrays.equals((Object[])value, (Object[])defaultValue) : !value.equals(defaultValue)) {
                            return value;
                        }
                    }
                    nextSource = source.getSuperclass();
                }
                return foundAnnotation ? defaultValue : null;
            }
        });
    }

    private static <T> T getValue(Annotation annotation, Method field) {
        try {
            return (T)field.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

