/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.arquillian.cube.docker.impl.await.SleepingAwaitStrategyBase;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.util.Ping;
import org.arquillian.cube.docker.impl.util.PingCommand;
import org.arquillian.cube.impl.util.IOUtil;
import org.arquillian.cube.spi.Cube;

public class HttpAwaitStrategy
extends SleepingAwaitStrategyBase {
    public static final String TAG = "http";
    private static final String REGEXP_PREFIX = "regexp:";
    private static final String DOCKER_HOST = "dockerHost";
    private static final int DEFAULT_POLL_ITERATIONS = 10;
    private int pollIterations = 10;
    private URL url = null;
    private int responseCode = 200;
    private Map<String, Object> headers;
    private String matcher;
    private Cube<?> cube;
    private DockerClientExecutor dockerClientExecutor;
    private HttpURLConnection urlConnection;

    public HttpAwaitStrategy(Cube<?> cube, DockerClientExecutor dockerClientExecutor, Await params) {
        super(params.getSleepPollingTime());
        this.cube = cube;
        this.dockerClientExecutor = dockerClientExecutor;
        if (params.getIterations() != null) {
            this.pollIterations = params.getIterations();
        }
        if (params.getUrl() != null) {
            String url = params.getUrl();
            if (url.contains(DOCKER_HOST)) {
                url = url.replaceAll(DOCKER_HOST, dockerClientExecutor.getDockerServerIp());
            }
            try {
                this.url = new URL(url);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            throw new IllegalArgumentException("Http Await Strategy requires url field");
        }
        if (params.getResponseCode() != null) {
            this.responseCode = params.getResponseCode();
        }
        if (params.getHeaders() != null) {
            this.headers = params.getHeaders();
        }
        if (params.getMatch() != null) {
            this.matcher = params.getMatch();
        }
    }

    public boolean await() {
        return Ping.ping(this.pollIterations, this.getSleepTime(), this.getTimeUnit(), new PingCommand(){

            @Override
            public boolean call() {
                try {
                    HttpAwaitStrategy.this.urlConnection = (HttpURLConnection)HttpAwaitStrategy.this.url.openConnection();
                    HttpAwaitStrategy.this.urlConnection.connect();
                    int connectionResponseCode = HttpAwaitStrategy.this.urlConnection.getResponseCode();
                    if (HttpAwaitStrategy.this.responseCode != connectionResponseCode) {
                        return false;
                    }
                    if (HttpAwaitStrategy.this.matcher != null) {
                        boolean matches;
                        String pattern;
                        boolean matches2;
                        String content = IOUtil.asString((InputStream)HttpAwaitStrategy.this.urlConnection.getInputStream());
                        if (HttpAwaitStrategy.this.matcher.startsWith(HttpAwaitStrategy.REGEXP_PREFIX) ? !(matches2 = Pattern.compile(pattern = HttpAwaitStrategy.this.matcher.substring(HttpAwaitStrategy.REGEXP_PREFIX.length()), 32).matcher(content).matches()) : !(matches = content.startsWith(HttpAwaitStrategy.this.matcher))) {
                            return false;
                        }
                    }
                    if (HttpAwaitStrategy.this.headers != null) {
                        Set keys = HttpAwaitStrategy.this.headers.keySet();
                        for (String key : keys) {
                            if (HttpAwaitStrategy.this.urlConnection.getHeaderField(key) != null) {
                                String connectionHeaderValue = HttpAwaitStrategy.this.urlConnection.getHeaderField(key);
                                if (connectionHeaderValue.equals(HttpAwaitStrategy.this.headers.get(key))) continue;
                                return false;
                            }
                            return false;
                        }
                    }
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        });
    }

    public String getUrl() {
        if (this.url == null) {
            return "";
        }
        return this.url.toString();
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getMatcher() {
        return this.matcher;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public int getPollIterations() {
        return this.pollIterations;
    }
}

