/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Logger;
import org.arquillian.cube.HostIpContext;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.CubeDockerConfigurationResolver;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.util.Boot2Docker;
import org.arquillian.cube.docker.impl.util.DockerMachine;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.docker.impl.util.OperatingSystemResolver;
import org.arquillian.cube.docker.impl.util.Top;
import org.arquillian.cube.spi.CubeConfiguration;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class CubeDockerConfigurator {
    private static Random random = new Random();
    private static Logger log = Logger.getLogger(CubeDockerConfigurator.class.getName());
    public static final String DOCKER_HOST = "DOCKER_HOST";
    private static final String EXTENSION_NAME = "docker";
    @Inject
    @ApplicationScoped
    private InstanceProducer<CubeDockerConfiguration> configurationProducer;
    @Inject
    @ApplicationScoped
    private InstanceProducer<HostIpContext> hostUriContextInstanceProducer;
    @Inject
    private Instance<Boot2Docker> boot2DockerInstance;
    @Inject
    private Instance<DockerMachine> dockerMachineInstance;
    @Inject
    private Instance<Top> topInstance;
    @Inject
    private Instance<Injector> injectorInstance;
    @Inject
    @ApplicationScoped
    private InstanceProducer<OperatingSystemFamily> operatingSystemFamilyInstanceProducer;

    public void configure(@Observes CubeConfiguration event, ArquillianDescriptor arquillianDescriptor) {
        this.configure(arquillianDescriptor);
    }

    private void configure(ArquillianDescriptor arquillianDescriptor) {
        this.operatingSystemFamilyInstanceProducer.set((Object)new OperatingSystemResolver().currentOperatingSystem().getFamily());
        Map config = arquillianDescriptor.extension(EXTENSION_NAME).getExtensionProperties();
        CubeDockerConfigurationResolver resolver = new CubeDockerConfigurationResolver((Top)this.topInstance.get(), (DockerMachine)this.dockerMachineInstance.get(), (Boot2Docker)this.boot2DockerInstance.get(), (OperatingSystemFamily)((Object)this.operatingSystemFamilyInstanceProducer.get()));
        resolver.resolve(config);
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(config, (Injector)this.injectorInstance.get());
        cubeConfiguration = this.resolveDynamicNames(cubeConfiguration);
        System.out.println(cubeConfiguration);
        this.hostUriContextInstanceProducer.set((Object)new HostIpContext(cubeConfiguration.getDockerServerIp()));
        this.configurationProducer.set((Object)cubeConfiguration);
    }

    CubeDockerConfiguration resolveDynamicNames(CubeDockerConfiguration cubeConfiguration) {
        HashMap<String, CubeContainer> resolvedContainers = new HashMap<String, CubeContainer>();
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        Map<String, CubeContainer> containers = dockerContainersContent.getContainers();
        UUID uuid = UUID.randomUUID();
        for (Map.Entry<String, CubeContainer> container : containers.entrySet()) {
            String containerId = container.getKey();
            if (containerId.endsWith("*")) {
                String templateName = containerId.substring(0, containerId.lastIndexOf(42));
                CubeContainer cubeContainer = container.getValue();
                this.adaptPortBindingToParallelRun(cubeContainer);
                this.adaptLinksToParallelRun(uuid, cubeContainer);
                String newId = this.generateNewName(templateName, uuid);
                resolvedContainers.put(newId, cubeContainer);
                continue;
            }
            resolvedContainers.put(containerId, container.getValue());
        }
        dockerContainersContent.setContainers(resolvedContainers);
        return cubeConfiguration;
    }

    private void adaptLinksToParallelRun(UUID uuid, CubeContainer cubeContainer) {
        Collection<Link> links = cubeContainer.getLinks();
        if (links == null) {
            return;
        }
        for (Link link : links) {
            Collection<String> env;
            if (!link.getName().endsWith("*")) continue;
            String linkTemplate = link.getName().substring(0, link.getName().lastIndexOf(42));
            link.setName(this.generateNewName(linkTemplate, uuid));
            String environmentVariable = linkTemplate.toUpperCase() + "_HOSTNAME=" + link.getName();
            if (link.isAliasSet()) {
                link.setAlias(this.generateNewName(link.getAlias(), uuid));
                environmentVariable = linkTemplate.toUpperCase() + "_HOSTNAME=" + link.getAlias();
            }
            if ((env = cubeContainer.getEnv()) != null) {
                if (env.contains(environmentVariable)) {
                    env.remove(environmentVariable);
                }
            } else {
                cubeContainer.setEnv(new ArrayList<String>());
            }
            cubeContainer.getEnv().add(environmentVariable);
        }
    }

    private void adaptPortBindingToParallelRun(CubeContainer cubeContainer) {
        Collection<PortBinding> portBindings = cubeContainer.getPortBindings();
        if (portBindings == null) {
            return;
        }
        for (PortBinding portBinding : portBindings) {
            int randomPrivatePort = this.generateRandomPrivatePort();
            portBinding.setBound(randomPrivatePort);
        }
    }

    private String generateNewName(String containerName, UUID uuid) {
        return containerName + "_" + uuid;
    }

    private int generateRandomPrivatePort() {
        int randomPort = random.nextInt(16383);
        return randomPort + 49152;
    }
}

