/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.metadata;

import java.util.Collection;
import java.util.EnumSet;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.metadata.CanReportMetrics;
import org.arquillian.recorder.reporter.Reportable;
import org.arquillian.recorder.reporter.model.entry.GroupEntry;
import org.arquillian.recorder.reporter.model.entry.KeyValueEntry;

public class ReportMetrics
implements CanReportMetrics {
    private DockerCube dockerCube;

    public ReportMetrics(DockerCube dockerCube) {
        this.dockerCube = dockerCube;
    }

    public Reportable report() {
        GroupEntry groupEntry = new GroupEntry(this.dockerCube.getId());
        boolean error = EnumSet.of(Cube.State.START_FAILED, Cube.State.CREATE_FAILED, Cube.State.STOP_FAILED, Cube.State.DESTORY_FAILED).contains(this.dockerCube.state());
        KeyValueEntry errorKeyValue = new KeyValueEntry("Error during lifecycle", Boolean.toString(error));
        groupEntry.getPropertyEntries().add(errorKeyValue);
        KeyValueEntry startingTime = new KeyValueEntry("Starting Time", String.format("%s ms", this.dockerCube.getStartingTimeInMillis()));
        KeyValueEntry stoppingTime = new KeyValueEntry("Stopping Time", String.format("%s ms", this.dockerCube.getStoppingTimeInMillis()));
        groupEntry.getPropertyEntries().add(startingTime);
        groupEntry.getPropertyEntries().add(stoppingTime);
        groupEntry.getPropertyEntries().add(this.writeProperties(this.dockerCube.getId(), this.dockerCube.configuration()));
        return groupEntry;
    }

    private GroupEntry writeProperties(String containerId, CubeContainer cubeContainer) {
        GroupEntry row = new GroupEntry("Docker Cube Properties");
        row.getPropertyEntries().add(ReportMetrics.cell("Container Name", containerId));
        KeyValueEntry image = cubeContainer.getImage() != null ? ReportMetrics.cell("Image", cubeContainer.getImage().toString()) : ReportMetrics.cell("Build", cubeContainer.getBuildImage().getDockerfileLocation());
        row.getPropertyEntries().add(image);
        if (cubeContainer.getExposedPorts() != null) {
            row.getPropertyEntries().add(ReportMetrics.cell("Exposed Ports", cubeContainer.getExposedPorts()));
        }
        if (cubeContainer.getPortBindings() != null) {
            row.getPropertyEntries().add(ReportMetrics.cell("Port Binding", cubeContainer.getPortBindings()));
        }
        if (cubeContainer.getLinks() != null) {
            row.getPropertyEntries().add(ReportMetrics.cell("Links", cubeContainer.getLinks()));
        }
        if (cubeContainer.getVolumes() != null) {
            row.getPropertyEntries().add(ReportMetrics.cell("Volumes", cubeContainer.getVolumes()));
        }
        if (cubeContainer.getBinds() != null) {
            row.getPropertyEntries().add(ReportMetrics.cell("Binds", cubeContainer.getBinds()));
        }
        if (cubeContainer.getEntryPoint() != null) {
            row.getPropertyEntries().add(ReportMetrics.cell("Entrypoint", cubeContainer.getEntryPoint()));
        }
        if (cubeContainer.getNetworkMode() != null) {
            row.getPropertyEntries().add(ReportMetrics.cell("Network Mode", cubeContainer.getNetworkMode()));
        }
        return row;
    }

    private static KeyValueEntry cell(String key, String content) {
        return new KeyValueEntry(key, content);
    }

    private static KeyValueEntry cell(String key, Collection content) {
        return new KeyValueEntry(key, content.toString());
    }
}

