/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.util.AutoStartOrderUtil;
import org.arquillian.cube.spi.AutoStartParser;
import org.arquillian.cube.spi.Node;

public class AutomaticResolutionLinksAutoStartParser
implements AutoStartParser {
    private List<String> deployableContainers;
    private DockerCompositions containerDefinition;

    public AutomaticResolutionLinksAutoStartParser(List<String> deployableContainers, DockerCompositions containerDefinitions) {
        this.deployableContainers = deployableContainers;
        this.containerDefinition = containerDefinitions;
    }

    public Map<String, Node> parse() {
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        for (String deployableContainer : this.deployableContainers) {
            CubeContainer content = this.containerDefinition.get(deployableContainer);
            if (content == null) {
                return nodes;
            }
            Collection<String> dependencies = content.getDependingContainers();
            for (String name : dependencies) {
                if (this.containerDefinition.get(name) == null) continue;
                Node child = Node.from((String)name);
                nodes.put(name, child);
            }
        }
        return nodes;
    }

    public String toString() {
        return AutoStartOrderUtil.toString(this.parse());
    }
}

