/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ContainerObjectUtil {
    private ContainerObjectUtil() {
    }

    public static List<? extends Annotation> getAllAnnotations(Class<?> source, Class<? extends Annotation> annotationClass) {
        return AccessController.doPrivileged(() -> {
            ArrayList annotations = new ArrayList();
            for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                Annotation[] annotationsByType = nextSource.getAnnotationsByType(annotationClass);
                Collections.addAll(annotations, annotationsByType);
            }
            return annotations;
        });
    }

    public static <T> T getTopCubeAttribute(Class<?> source, String nameField, Class<? extends Annotation> annotationClass, T defaultValue) {
        return (T)AccessController.doPrivileged(() -> {
            Method field = null;
            try {
                field = annotationClass.getMethod(nameField, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            boolean foundAnnotation = false;
            for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                if (!nextSource.isAnnotationPresent(annotationClass)) continue;
                foundAnnotation = true;
                Object annotation = nextSource.getAnnotation(annotationClass);
                Object value = ContainerObjectUtil.getValue(annotation, field);
                if (!(defaultValue.getClass().isArray() ? (defaultValue.getClass().getComponentType().isPrimitive() ? !Arrays.equals((int[])value, (int[])defaultValue) : !Arrays.equals((Object[])value, (Object[])defaultValue)) : !value.equals(defaultValue))) continue;
                return value;
            }
            return foundAnnotation ? defaultValue : null;
        });
    }

    private static <T> T getValue(Annotation annotation, Method field) {
        try {
            return (T)field.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

