/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.config;

import java.util.ArrayList;
import java.util.Collection;

public class Link {
    private String name;
    private String alias;

    public Link(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAliasSet() {
        return this.alias != null;
    }

    public String getAlias() {
        if (this.alias == null) {
            return this.name;
        }
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.alias != null) {
            sb.append(":").append(this.alias);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Link other = (Link)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static Link valueOf(String links) {
        String[] link = links.split(":");
        String name = link[0];
        String alias = null;
        if (link.length == 2) {
            alias = link[1];
        }
        return new Link(name, alias);
    }

    public static Collection<Link> valuesOf(Collection<String> links) {
        if (links == null) {
            return null;
        }
        ArrayList<Link> result = new ArrayList<Link>();
        for (String link : links) {
            result.add(Link.valueOf(link));
        }
        return result;
    }
}

