/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.model;

import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.docker.impl.util.OperatingSystemResolver;

public enum DockerMachineDistro {
    LINUX(new OperatingSystemFamily[]{OperatingSystemFamily.LINUX}, "docker-machine-Linux-x86_64"),
    OSX(new OperatingSystemFamily[]{OperatingSystemFamily.MAC}, "docker-machine-Darwin-x86_64"),
    WIN_64(new OperatingSystemFamily[]{OperatingSystemFamily.WINDOWS}, "docker-machine-Windows-x86_64.exe");

    private OperatingSystemFamily[] osFamily;
    private String distro;

    private DockerMachineDistro(OperatingSystemFamily[] osFamily, String distro) {
        this.osFamily = osFamily;
        this.distro = distro;
    }

    public static String resolveDistro() {
        OperatingSystemFamily currentOSFamily = new OperatingSystemResolver().currentOperatingSystem().getFamily();
        for (DockerMachineDistro distro : DockerMachineDistro.values()) {
            for (OperatingSystemFamily osFamily : distro.osFamily) {
                if (osFamily != currentOSFamily) continue;
                return distro.distro;
            }
        }
        return null;
    }
}

