/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.spi.AutoStartParser;
import org.arquillian.cube.spi.Node;

public class AutomaticResolutionNetworkAutoStartParser
implements AutoStartParser {
    private List<String> deployableContainers;
    private DockerCompositions containerDefinition;

    public AutomaticResolutionNetworkAutoStartParser(List<String> deployableContainers, DockerCompositions containerDefinitions) {
        this.deployableContainers = deployableContainers;
        this.containerDefinition = containerDefinitions;
    }

    public Map<String, Node> parse() {
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        Set<String> networksIds = this.containerDefinition.getNetworkIds();
        for (Map.Entry<String, CubeContainer> container : this.containerDefinition.getNoneManualContainers().entrySet()) {
            String networkMode;
            if (this.deployableContainers.contains(container.getKey()) || (networkMode = container.getValue().getNetworkMode()) == null || !networksIds.contains(networkMode)) continue;
            String name = container.getKey();
            Node child = Node.from((String)name);
            nodes.put(name, child);
        }
        return nodes;
    }
}

