/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.arquillian.cube.ContainerObjectConfiguration;
import org.arquillian.cube.ContainerObjectFactory;
import org.arquillian.cube.containerobject.Cube;
import org.arquillian.cube.containerobject.Environment;
import org.arquillian.cube.containerobject.Link;
import org.arquillian.cube.containerobject.Volume;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.client.containerobject.CubeContainerObjectConfiguration;
import org.arquillian.cube.impl.util.ReflectionUtil;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;

public class CubeContainerObjectTestEnricher
implements TestEnricher {
    private static final Logger logger = Logger.getLogger(CubeContainerObjectTestEnricher.class.getName());
    @Inject
    Instance<ContainerObjectFactory> containerObjectFactoryInstance;

    public void enrich(Object testCase) {
        List cubeFields = ReflectionUtil.getFieldsWithAnnotation(testCase.getClass(), Cube.class);
        if (cubeFields.size() > 0) {
            for (Field cubeField : cubeFields) {
                try {
                    logger.fine(String.format("Creating Container Object for field %s", cubeField.getName()));
                    this.enrichField(testCase, cubeField);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    private void enrichField(Object testCase, Field field) throws IllegalAccessException {
        Object cubeContainerObject = field.get(testCase);
        if (cubeContainerObject == null) {
            Class<?> cubeContainerClazz = field.getType();
            ContainerObjectConfiguration configuration = CubeContainerObjectTestEnricher.extractConfigFrom(field);
            Object containerObjectInstance = ((ContainerObjectFactory)this.containerObjectFactoryInstance.get()).createContainerObject(cubeContainerClazz, configuration, testCase);
            field.set(testCase, containerObjectInstance);
        }
    }

    public Object[] resolve(Method method) {
        return new Object[0];
    }

    private static ContainerObjectConfiguration extractConfigFrom(Field field) {
        return new CubeContainerObjectConfiguration(CubeContainerObjectTestEnricher.extractCubeContainerFrom(field));
    }

    private static CubeContainer extractCubeContainerFrom(Field field) {
        Link[] linksFromAnnotations;
        Volume[] volumesFromAnnotations;
        Environment[] environmentVariablesFromAnnotations;
        int[] awaitPortsFromAnnotation;
        Object[] portBindingsFromAnnotation;
        CubeContainer cubeContainer = new CubeContainer();
        Cube cubeAnnotation = field.getAnnotation(Cube.class);
        if (cubeAnnotation == null) {
            throw new IllegalArgumentException(String.format("Field %s requires to be annotated with %s annotation", field.getName(), Cube.class.getSimpleName()));
        }
        String cubeName = cubeAnnotation.value();
        if (cubeName != null && !"".equals(cubeName)) {
            cubeContainer.setContainerName(cubeName);
        }
        if ((portBindingsFromAnnotation = cubeAnnotation.portBinding()) != null && !Arrays.equals(portBindingsFromAnnotation, Cube.DEFAULT_PORT_BINDING)) {
            List<PortBinding> portBindings = Arrays.stream(portBindingsFromAnnotation).map(PortBinding::valueOf).collect(Collectors.toList());
            cubeContainer.setPortBindings(portBindings);
        }
        if ((awaitPortsFromAnnotation = cubeAnnotation.awaitPorts()) != null && !Arrays.equals(awaitPortsFromAnnotation, Cube.DEFAULT_AWAIT_PORT_BINDING)) {
            Await await = new Await();
            await.setStrategy("polling");
            await.setPorts(Arrays.asList(ArrayUtils.toObject((int[])awaitPortsFromAnnotation)));
            cubeContainer.setAwait(await);
        }
        if ((environmentVariablesFromAnnotations = (Environment[])field.getAnnotationsByType(Environment.class)) != null && environmentVariablesFromAnnotations.length > 0) {
            List<String> environmentVariables = Arrays.stream(environmentVariablesFromAnnotations).map(environment -> environment.key() + "=" + environment.value()).collect(Collectors.toList());
            cubeContainer.setEnv(environmentVariables);
        }
        if ((volumesFromAnnotations = (Volume[])field.getAnnotationsByType(Volume.class)) != null && volumesFromAnnotations.length > 0) {
            List<String> volumeBindings = Arrays.stream(volumesFromAnnotations).map(volume -> volume.hostPath() + ":" + volume.containerPath() + ":rw").collect(Collectors.toList());
            cubeContainer.setBinds(volumeBindings);
        }
        if ((linksFromAnnotations = (Link[])field.getAnnotationsByType(Link.class)) != null && linksFromAnnotations.length > 0) {
            List<org.arquillian.cube.docker.impl.client.config.Link> links = Arrays.stream(linksFromAnnotations).map(Link::value).map(org.arquillian.cube.docker.impl.client.config.Link::valueOf).collect(Collectors.toList());
            cubeContainer.setLinks(links);
        }
        return cubeContainer;
    }
}

