/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import org.arquillian.cube.ContainerObjectConfiguration;
import org.arquillian.cube.ContainerObjectFactory;
import org.arquillian.cube.CubeController;
import org.arquillian.cube.docker.impl.client.containerobject.CubeContainerObjectConfiguration;
import org.arquillian.cube.docker.impl.client.containerobject.DockerContainerObjectBuilder;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestEnricher;

public class DockerContainerObjectFactory
implements ContainerObjectFactory {
    private static final Logger logger = Logger.getLogger(DockerContainerObjectFactory.class.getName());
    @Inject
    Instance<ServiceLoader> serviceLoaderInstance;
    @Inject
    Instance<DockerClientExecutor> dockerClientExecutorInstance;
    @Inject
    Instance<CubeRegistry> cubeRegistryInstance;
    @Inject
    Instance<CubeController> cubeControllerInstance;
    @Inject
    Instance<Injector> injectorInstance;

    public <T> T createContainerObject(Class<T> containerObjectClass) {
        return this.createContainerObject(containerObjectClass, CubeContainerObjectConfiguration.empty(), null);
    }

    public <T> T createContainerObject(Class<T> containerObjectClass, ContainerObjectConfiguration configuration) {
        return this.createContainerObject(containerObjectClass, configuration, null);
    }

    public <T> T createContainerObject(Class<T> containerObjectClass, ContainerObjectConfiguration configuration, Object containerObjectContainer) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        try {
            return new DockerContainerObjectBuilder((DockerClientExecutor)this.dockerClientExecutorInstance.get(), (CubeController)this.cubeControllerInstance.get()).withEnrichers(((ServiceLoader)this.serviceLoaderInstance.get()).all(TestEnricher.class)).withContainerObjectClass(containerObjectClass).withContainerObjectConfiguration(configuration).withContainerObjectContainer(containerObjectContainer).onCubeCreated(this::onCubeCreated).build();
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void onCubeCreated(DockerCube cube) {
        ((Injector)this.injectorInstance.get()).inject((Object)cube);
        ((CubeRegistry)this.cubeRegistryInstance.get()).addCube((Cube)cube);
    }
}

