/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.await;

import java.util.Map;
import java.util.logging.Logger;
import org.arquillian.cube.impl.await.AwaitStrategy;
import org.arquillian.cube.impl.await.NativeAwaitStrategy;
import org.arquillian.cube.impl.await.PollingAwaitStrategy;
import org.arquillian.cube.impl.await.StaticAwaitStrategy;
import org.arquillian.cube.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.Cube;

public class AwaitStrategyFactory {
    private static final Logger log = Logger.getLogger(AwaitStrategyFactory.class.getName());
    private static final String AWAIT = "await";
    private static final String STRATEGY = "strategy";

    private AwaitStrategyFactory() {
    }

    public static final AwaitStrategy create(DockerClientExecutor dockerClientExecutor, Cube cube, Map<String, Object> options) {
        if (options.containsKey(AWAIT)) {
            Map awaitOptions = (Map)options.get(AWAIT);
            if (awaitOptions.containsKey(STRATEGY)) {
                String strategy;
                switch (strategy = ((String)awaitOptions.get(STRATEGY)).toLowerCase()) {
                    case "polling": {
                        return new PollingAwaitStrategy(cube, awaitOptions);
                    }
                    case "native": {
                        return new NativeAwaitStrategy(cube, dockerClientExecutor);
                    }
                    case "static": {
                        return new StaticAwaitStrategy(cube, awaitOptions);
                    }
                }
                return new NativeAwaitStrategy(cube, dockerClientExecutor);
            }
            log.warning("No await strategy is set and Native one is going to be used.");
            return new NativeAwaitStrategy(cube, dockerClientExecutor);
        }
        log.warning("No await strategy is set and Native one is going to be used.");
        return new NativeAwaitStrategy(cube, dockerClientExecutor);
    }
}

