/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.client;

import org.arquillian.cube.CubeController;
import org.arquillian.cube.CubeID;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.CreateCube;
import org.arquillian.cube.spi.event.CubeControlEvent;
import org.arquillian.cube.spi.event.DestroyCube;
import org.arquillian.cube.spi.event.StartCube;
import org.arquillian.cube.spi.event.StopCube;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Validate;

public class ClientCubeController
implements CubeController {
    @Inject
    private Instance<CubeRegistry> cubeRegistry;
    @Inject
    private Event<CubeControlEvent> controlEvent;

    public void create(CubeID cubeId) {
        this.create(cubeId.get());
    }

    public void start(CubeID cubeId) {
        this.start(cubeId.get());
    }

    public void stop(CubeID cubeId) {
        this.stop(cubeId.get());
    }

    public void destroy(CubeID cubeId) {
        this.destroy(cubeId.get());
    }

    public void create(String cubeId) {
        Cube cube = ((CubeRegistry)this.cubeRegistry.get()).getCube(cubeId);
        Validate.notNull((Object)cube, (String)("Cube with id '" + cubeId + "' to create does not exist."));
        this.controlEvent.fire((Object)new CreateCube(cubeId));
    }

    public void start(String cubeId) {
        Cube cube = ((CubeRegistry)this.cubeRegistry.get()).getCube(cubeId);
        Validate.notNull((Object)cube, (String)("Cube with id '" + cubeId + "' to start does not exist."));
        this.controlEvent.fire((Object)new StartCube(cubeId));
    }

    public void stop(String cubeId) {
        Cube cube = ((CubeRegistry)this.cubeRegistry.get()).getCube(cubeId);
        Validate.notNull((Object)cube, (String)("Cube with id '" + cubeId + "' to stop does not exist."));
        this.controlEvent.fire((Object)new StopCube(cubeId));
    }

    public void destroy(String cubeId) {
        Cube cube = ((CubeRegistry)this.cubeRegistry.get()).getCube(cubeId);
        Validate.notNull((Object)cube, (String)("Cube with id '" + cubeId + "' to destroy does not exist."));
        this.controlEvent.fire((Object)new DestroyCube(cubeId));
    }
}

