/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.client.container;

import org.arquillian.cube.impl.util.ContainerUtil;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.CreateCube;
import org.arquillian.cube.spi.event.CubeControlEvent;
import org.arquillian.cube.spi.event.DestroyCube;
import org.arquillian.cube.spi.event.StartCube;
import org.arquillian.cube.spi.event.StopCube;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.event.container.AfterStop;
import org.jboss.arquillian.container.spi.event.container.BeforeStart;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class CubeContainerLifecycleController {
    @Inject
    private Event<CubeControlEvent> controlEvent;

    public void startCubeMappedContainer(@Observes BeforeStart event, CubeRegistry cubeRegistry, ContainerRegistry containerRegistry) {
        Container container = ContainerUtil.getContainerByDeployableContainer(containerRegistry, event.getDeployableContainer());
        if (container == null) {
            return;
        }
        Cube cube = cubeRegistry.getCube(container.getName());
        if (cube == null) {
            return;
        }
        this.controlEvent.fire((Object)new CreateCube(cube));
        this.controlEvent.fire((Object)new StartCube(cube));
    }

    public void stopCubeMappedContainer(@Observes AfterStop event, CubeRegistry cubeRegistry, ContainerRegistry containerRegistry) {
        Container container = ContainerUtil.getContainerByDeployableContainer(containerRegistry, event.getDeployableContainer());
        if (container == null) {
            return;
        }
        Cube cube = cubeRegistry.getCube(container.getName());
        if (cube == null) {
            return;
        }
        this.controlEvent.fire((Object)new StopCube(cube));
        this.controlEvent.fire((Object)new DestroyCube(cube));
    }
}

