/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.client.container.remote;

import org.arquillian.cube.CubeController;
import org.arquillian.cube.CubeID;
import org.arquillian.cube.impl.client.container.remote.command.CreateCubeCommand;
import org.arquillian.cube.impl.client.container.remote.command.DestroyCubeCommand;
import org.arquillian.cube.impl.client.container.remote.command.StartCubeCommand;
import org.arquillian.cube.impl.client.container.remote.command.StopCubeCommand;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandService;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;

public class ContainerCubeController
implements CubeController {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public void create(CubeID cubeId) {
        this.create(cubeId.get());
    }

    public void start(CubeID cubeId) {
        this.start(cubeId.get());
    }

    public void stop(CubeID cubeId) {
        this.stop(cubeId.get());
    }

    public void destroy(CubeID cubeId) {
        this.destroy(cubeId.get());
    }

    public void create(String cubeId) {
        this.getCommandService().execute((Command)new CreateCubeCommand(cubeId));
    }

    public void start(String cubeId) {
        this.getCommandService().execute((Command)new StartCubeCommand(cubeId));
    }

    public void stop(String cubeId) {
        this.getCommandService().execute((Command)new StopCubeCommand(cubeId));
    }

    public void destroy(String cubeId) {
        this.getCommandService().execute((Command)new DestroyCubeCommand(cubeId));
    }

    private CommandService getCommandService() {
        ServiceLoader loader = (ServiceLoader)this.serviceLoader.get();
        if (loader == null) {
            throw new IllegalStateException("No " + ServiceLoader.class.getName() + " found in context");
        }
        CommandService service = (CommandService)loader.onlyOne(CommandService.class);
        if (service == null) {
            throw new IllegalStateException("No " + CommandService.class.getName() + " found in context");
        }
        return service;
    }
}

