/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.model;

import java.util.Map;
import java.util.logging.Logger;
import org.arquillian.cube.impl.await.AwaitStrategyFactory;
import org.arquillian.cube.impl.docker.DockerClientExecutor;
import org.arquillian.cube.impl.util.BindingUtil;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeControlException;
import org.arquillian.cube.spi.event.lifecycle.AfterCreate;
import org.arquillian.cube.spi.event.lifecycle.AfterDestroy;
import org.arquillian.cube.spi.event.lifecycle.AfterStart;
import org.arquillian.cube.spi.event.lifecycle.AfterStop;
import org.arquillian.cube.spi.event.lifecycle.BeforeCreate;
import org.arquillian.cube.spi.event.lifecycle.BeforeDestroy;
import org.arquillian.cube.spi.event.lifecycle.BeforeStart;
import org.arquillian.cube.spi.event.lifecycle.BeforeStop;
import org.arquillian.cube.spi.event.lifecycle.CubeLifecyleEvent;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;

public class DockerCube
implements Cube {
    private static final Logger log = Logger.getLogger(DockerCube.class.getName());
    private Cube.State state = Cube.State.DESTROYED;
    private String id;
    private Binding binding = null;
    private Map<String, Object> configuration;
    @Inject
    private Event<CubeLifecyleEvent> lifecycle;
    private DockerClientExecutor executor;

    public DockerCube(String id, Map<String, Object> configuration, DockerClientExecutor executor) {
        this.id = id;
        this.configuration = configuration;
        this.executor = executor;
    }

    public Cube.State state() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public void create() throws CubeControlException {
        if (this.state != Cube.State.DESTROYED) {
            return;
        }
        try {
            this.lifecycle.fire((Object)new BeforeCreate(this.id));
            log.fine(String.format("Creating container with name %s and configuration %s.", this.id, this.configuration));
            this.executor.createContainer(this.id, this.configuration);
            log.fine(String.format("Created container with id %s.", this.id));
            this.state = Cube.State.CREATED;
            this.lifecycle.fire((Object)new AfterCreate(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.CREATE_FAILED;
            throw CubeControlException.failedCreate((String)this.id, (Throwable)e);
        }
    }

    public void start() throws CubeControlException {
        if (this.state == Cube.State.STARTED) {
            return;
        }
        try {
            this.lifecycle.fire((Object)new BeforeStart(this.id));
            this.executor.startContainer(this.id, this.configuration);
            this.state = Cube.State.STARTED;
            if (!AwaitStrategyFactory.create(this.executor, this, this.configuration).await()) {
                throw new IllegalArgumentException(String.format("Cannot connect to %s container", this.id));
            }
            this.lifecycle.fire((Object)new AfterStart(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.START_FAILED;
            throw CubeControlException.failedStart((String)this.id, (Throwable)e);
        }
    }

    public void stop() throws CubeControlException {
        if (this.state == Cube.State.STOPPED) {
            return;
        }
        try {
            this.lifecycle.fire((Object)new BeforeStop(this.id));
            this.executor.stopContainer(this.id);
            this.state = Cube.State.STOPPED;
            this.lifecycle.fire((Object)new AfterStop(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.STOP_FAILED;
            throw CubeControlException.failedStop((String)this.id, (Throwable)e);
        }
    }

    public void destroy() throws CubeControlException {
        if (this.state != Cube.State.STOPPED) {
            return;
        }
        try {
            this.lifecycle.fire((Object)new BeforeDestroy(this.id));
            this.executor.removeContainer(this.id);
            this.state = Cube.State.DESTROYED;
            this.lifecycle.fire((Object)new AfterDestroy(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.DESTORY_FAILED;
            throw CubeControlException.failedDestroy((String)this.id, (Throwable)e);
        }
    }

    public Binding bindings() {
        if (this.binding != null) {
            return this.binding;
        }
        if (this.state != Cube.State.STARTED) {
            throw new IllegalStateException("Can't get binding for cube " + this.id + " when status not " + Cube.State.STARTED + ". Status is " + this.state);
        }
        this.binding = BindingUtil.binding(this.executor, this.id);
        return this.binding;
    }

    public Map<String, Object> configuration() {
        return this.configuration;
    }
}

