/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.util;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.Binding;

public final class BindingUtil {
    public static final String PORTS_SEPARATOR = "->";
    private static final String NO_GATEWAY = null;

    private BindingUtil() {
    }

    public static Binding binding(DockerClientExecutor executor, String cubeId) {
        InspectContainerResponse inspectResponse = executor.getDockerClient().inspectContainerCmd(cubeId).exec();
        InspectContainerResponse.HostConfig hostConfig = inspectResponse.getHostConfig();
        String gatewayIp = inspectResponse.getNetworkSettings().getGateway();
        Binding binding = new Binding(gatewayIp);
        for (Map.Entry bind : hostConfig.getPortBindings().getBindings().entrySet()) {
            binding.addPortBinding(Integer.valueOf(((ExposedPort)bind.getKey()).getPort()), Integer.valueOf(((Ports.Binding)bind.getValue()).getHostPort()));
        }
        return binding;
    }

    public static Binding binding(Map<String, Object> cubeConfiguration) {
        Binding binding = new Binding(NO_GATEWAY);
        if (cubeConfiguration.containsKey("portBindings")) {
            List cubePortBindings = (List)cubeConfiguration.get("portBindings");
            for (String cubePortBinding : cubePortBindings) {
                int exposedPort;
                String[] elements = cubePortBinding.split(PORTS_SEPARATOR);
                if (elements.length == 1) {
                    exposedPort = Integer.parseInt(elements[0].substring(0, elements[0].indexOf("/")));
                    binding.addPortBinding(Integer.valueOf(exposedPort), Integer.valueOf(exposedPort));
                    continue;
                }
                if (elements.length != 2) continue;
                exposedPort = Integer.parseInt(elements[1].substring(0, elements[1].indexOf("/")));
                int port = Integer.parseInt(elements[0]);
                binding.addPortBinding(Integer.valueOf(exposedPort), Integer.valueOf(port));
            }
        }
        return binding;
    }
}

