/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.lifecycle.BeforeStop;
import org.jboss.arquillian.core.api.annotation.Observes;

public class BeforeStopContainerObserver {
    private static final String BEFORE_STOP = "beforeStop";
    private static final String COPY = "copy";
    private static final String LOG = "log";

    public void processCommands(@Observes BeforeStop beforeStop, CubeRegistry cubeRegistry, DockerClientExecutor dockerClientExecutor) throws IOException {
        Cube cube = cubeRegistry.getCube(beforeStop.getCubeId());
        Map configuration = cube.configuration();
        if (configuration.containsKey(BEFORE_STOP)) {
            List beforeStopConfiguration = (List)configuration.get(BEFORE_STOP);
            for (Map map : beforeStopConfiguration) {
                if (map.containsKey(COPY)) {
                    Map copyConfiguration = (Map)map.get(COPY);
                    dockerClientExecutor.copyFromContainer(beforeStop.getCubeId(), copyConfiguration);
                    continue;
                }
                if (!map.containsKey(LOG)) continue;
                Map logConfiguration = (Map)map.get(LOG);
                dockerClientExecutor.copyLog(beforeStop.getCubeId(), logConfiguration);
            }
        }
    }
}

