/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.client;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.arquillian.cube.impl.client.CubeConfiguration;
import org.arquillian.cube.impl.util.Boot2Docker;
import org.arquillian.cube.impl.util.HomeResolverUtil;
import org.arquillian.cube.impl.util.OperatingSystemResolver;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class CubeConfigurator {
    private static final String EXTENSION_NAME = "docker";
    private static final String UNIX_SOCKET_SCHEME = "unix";
    @Inject
    @ApplicationScoped
    private InstanceProducer<CubeConfiguration> configurationProducer;
    @Inject
    private Instance<Boot2Docker> boot2DockerInstance;

    public void configure(@Observes ArquillianDescriptor arquillianDescriptor) {
        Map<String, String> config = arquillianDescriptor.extension(EXTENSION_NAME).getExtensionProperties();
        config = this.resolveServerUriByOperativeSystem(config);
        config = this.resolveServerIp(config);
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(config);
        this.configurationProducer.set((Object)cubeConfiguration);
    }

    private Map<String, String> resolveServerIp(Map<String, String> config) {
        URI serverUri;
        String dockerServerUri = config.get("serverUri");
        if (dockerServerUri.contains("boot2docker")) {
            dockerServerUri = this.resolveBoot2Docker(dockerServerUri, config.get("boot2dockerPath"));
            config.put("serverUri", dockerServerUri);
            if (!config.containsKey("certPath")) {
                config.put("certPath", HomeResolverUtil.resolveHomeDirectoryChar(this.getDefaultTlsDirectory()));
            }
        }
        String serverIp = UNIX_SOCKET_SCHEME.equalsIgnoreCase((serverUri = URI.create(dockerServerUri)).getScheme()) ? "localhost" : serverUri.getHost();
        config.put("dockerServerIp", serverIp);
        return config;
    }

    private String resolveBoot2Docker(String tag, String boot2DockerPath) {
        return tag.replaceAll("boot2docker", ((Boot2Docker)this.boot2DockerInstance.get()).ip(boot2DockerPath, false));
    }

    private String getDefaultTlsDirectory() {
        return "~" + File.separator + ".boot2docker" + File.separator + "certs" + File.separator + "boot2docker-vm";
    }

    private Map<String, String> resolveServerUriByOperativeSystem(Map<String, String> cubeConfiguration) {
        if (!cubeConfiguration.containsKey("serverUri")) {
            String serverUri = new OperatingSystemResolver().currentOperatingSystem().getFamily().getServerUri();
            cubeConfiguration.put("serverUri", serverUri);
        }
        return cubeConfiguration;
    }
}

